@extends('backend.layouts.master-layout')
@section('title', config('app.name', 'laravel').' | '.$title)
@section('page-css')
@endsection
@section('content')
<div id="wrapper-content">
    <div class="row">
        <div class="col">
            <nav class="breadcrumb justify-content-sm-start justify-content-center text-center text-light bg-dark ">
                <a class="breadcrumb-item text-white" href="{{ route('admin.dashboard') }}">{{__('Home')}}</a>
                <span class="breadcrumb-item active">{{__($title)}}</span>
                <span class="breadcrumb-info" id="time"></span>
            </nav>
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card card-dark bg-dark">
                <div class="card-header">
                    <h6 class="card-title">{{__($title)}}</h6>
                </div>
                <form action="{{ route('admin.settings.general-save') }}" method="POST" enctype="multipart/form-data">
                    <div class="card-body">
                        @csrf
                        <!-- Site Name -->
                        <div class="mb-3">
                            <p class="mb-1">{{__('Site Name')}}: </p>
                            <div class="input-group input-group-lg">
                                <input type="text" name="site_name" class="form-control" aria-label="Large" aria-describedby="inputGroup-sizing-sm"
                                       placeholder="{{__('Site Name')}}" value="{{$generalSetting?clean($generalSetting->site_name):''}}">
                            </div>
                            @if ($errors->has('site_name'))
                                <span class="text-danger">{{ $errors->first('site_name') }}</span>
                            @endif
                        </div>

                        <!-- Site Tag Line -->
                        <div class="mb-3">
                            <p class="mb-1">{{__('Site Tag Line')}}: </p>
                            <div class="input-group input-group-lg">
                                <input type="text" name="site_tag_line" class="form-control" aria-label="Large" aria-describedby="inputGroup-sizing-sm"
                                       placeholder="{{__('Site Tag Line')}}" value="{{$generalSetting?clean($generalSetting->site_tag_line):''}}">
                            </div>
                            @if ($errors->has('site_tag_line'))
                                <span class="text-danger">{{ $errors->first('site_tag_line') }}</span>
                            @endif
                        </div>

                        <!-- Site Sub Tag Line -->
                        <div class="mb-3">
                            <p class="mb-1">{{__('Site Sub Tag Line')}}: </p>
                            <div class="input-group input-group-lg">
                                <input type="text" name="site_sub_tag_line" class="form-control" aria-label="Large" aria-describedby="inputGroup-sizing-sm"
                                       placeholder="{{__('Site Sub Tag Line')}}" value="{{$generalSetting?clean($generalSetting->site_sub_tag_line):''}}">
                            </div>
                            @if ($errors->has('site_sub_tag_line'))
                                <span class="text-danger">{{ $errors->first('site_sub_tag_line') }}</span>
                            @endif
                        </div>

                        <!-- Author Name -->
                        <div class="mb-3">
                            <p class="mb-1">{{__('Author Name')}}: </p>
                            <div class="input-group input-group-lg">
                                <input type="text" name="author_name" class="form-control" aria-label="Large" aria-describedby="inputGroup-sizing-sm"
                                       placeholder="{{__('Author Name')}}" value="{{$generalSetting?clean($generalSetting->author_name):''}}">
                            </div>
                            @if ($errors->has('author_name'))
                                <span class="text-danger">{{ $errors->first('author_name') }}</span>
                            @endif
                        </div>

                        <!-- Og Meta Title -->
                        <div class="mb-3">
                            <p class="mb-1">{{__('Og Meta Title')}}: </p>
                            <div class="input-group input-group-lg">
                                <input type="text" name="og_meta_title" class="form-control" aria-label="Large" aria-describedby="inputGroup-sizing-sm"
                                       placeholder="{{__('Og Meta Title')}}" value="{{$generalSetting?clean($generalSetting->og_meta_title):''}}">
                            </div>
                            @if ($errors->has('og_meta_title'))
                                <span class="text-danger">{{ $errors->first('og_meta_title') }}</span>
                            @endif
                        </div>

                        <!-- Og Meta Description -->
                        <div class="mb-3">
                            <p class="mb-1">{{__('Og Meta Description')}}: <code>{{__('maximum 50 word')}}</code></p>
                            <div class="input-group input-group-lg">
                <textarea class="form-control" name="og_meta_description" aria-label="With textarea"
                          rows="4">{{$generalSetting?clean($generalSetting->og_meta_description):''}}</textarea>
                            </div>
                            @if ($errors->has('og_meta_description'))
                                <span class="text-danger">{{ $errors->first('og_meta_description') }}</span>
                            @endif
                        </div>

                        <!-- Currency Symbol -->
                        <div class="mb-3">
                            <p class="mb-1">{{__('Currency Symbol')}}:</p>
                            <div class="input-group input-group-lg">
                                <input type="text" name="currency_symbol" class="form-control" aria-label="Large" aria-describedby="inputGroup-sizing-sm"
                                       placeholder="{{__('Currency Symbol')}}" value="{{$generalSetting?clean($generalSetting->currency_symbol):''}}">
                            </div>
                            @if ($errors->has('currency_symbol'))
                                <span class="text-danger">{{ $errors->first('currency_symbol') }}</span>
                            @endif
                        </div>

                        <!-- Google Map Api Key -->
                        <div class="mb-3">
                            <p class="mb-1">{{__('Google Map Api Key')}}:</p>
                            <div class="input-group input-group-lg">
                                <input type="text" name="google_map_api_key" class="form-control" aria-label="Large" aria-describedby="inputGroup-sizing-sm"
                                       placeholder="{{__('Api Key')}}" value="{{$generalSetting?clean($generalSetting->google_map_api_key):''}}">
                            </div>
                            @if ($errors->has('google_map_api_key'))
                                <span class="text-danger">{{ $errors->first('google_map_api_key') }}</span>
                            @endif
                        </div>

                        <!-- Og Meta Image -->
                        <div class="mb-3">
                            <p class="mb-1">{{__('Og Meta Image')}}: <code>{{__('expected size is 32x32px')}}</code></p>
                            <div class="form-row">
                                <div class="col-md-10 col-sm-12">
                                    <div class="form-group">
                                        <div role="button" class="btn btn-primary mr-2">
                                            <input type="file" title='Click to add Files' name="og_meta_image" />
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-2 d-md-block d-sm-none">
                                    <div class="img-favicon">
                                        @if($generalSetting)
                                            {!! imageShow($generalSetting->og_meta_image, 'Og Meta Image', 'img-thumbnail', '', 'App\Models\GeneralSettings', $generalSetting->id, 'og_meta_image') !!}
                                        @endif
                                    </div>
                                </div>
                            </div>
                            @if ($errors->has('og_meta_image'))
                                <span class="text-danger">{{ $errors->first('og_meta_image') }}</span>
                            @endif
                        </div>
                    </div>

                    <!-- Form Submit -->
                    <div class="card-footer">
                        <div class="wizard-action text-left">
                            <button class="btn btn-wave-light btn-danger btn-lg" type="submit">{{__('Submit form')}}</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@section('page-script')
    @include('backend.layouts.message')
    @include('backend.pages.delete-warning')
@endsection
