@extends('backend.layouts.master-layout')

@section('title', config('app.name', 'laravel') . ' | ' . $title)

@section('page-css')
    <link rel="stylesheet" href="{{ asset('backend/dynamic-menu/css/all.min.css') }}">
    <link rel="stylesheet" href="{{ asset('backend/dynamic-menu/css/bootstrap-iconpicker.min.css') }}" />
    <link rel="stylesheet" href="{{ asset('backend/dynamic-menu/css/nestable-menu.css') }}" />
@endsection

@section('content')
    <div id="wrapper-content">
        <div class="row">
            <div class="col">
                <nav class="breadcrumb justify-content-sm-start justify-content-center text-center text-light bg-dark ">
                    <a class="breadcrumb-item text-white" href="{{ route('admin.dashboard') }}">{{ __('Home') }}</a>
                    <span class="breadcrumb-item active">{{ __($title) }}</span>
                    <span class="breadcrumb-info" id="time"></span>
                </nav>
            </div>
        </div>

        <div class="row">
            <div class="container">
                <div class="row">
                    <div class="col-md-6">
                        <div class="card mb-3">
                            <div class="card-header d-block">
                                <h5 class="float-left">{{ __('Menu') }}</h5>
                            </div>
                            <div class="card-body">
                                <div class="dd" id="nestable">
                                    {!! $menuHtml !!}
                                </div>
                            </div>

                        </div>
                    </div>

                    <div class="col-md-6">
                        <form id="frmEdit" method="POST" action="{{ route('admin.menu.item.store.menu') }}"
                            class="form-horizontal">
                            @csrf
                            <div class="card border-primary mb-3">
                                <div class="card-header bg-primary text-white">{{ __('Edit item') }}</div>
                                <div class="card-body">
                                    <div class="form-group">
                                        <label for="text">{{ __('Text') }}</label>
                                        <div class="input-group">
                                            <input type="text" class="form-control item-menu" name="text" id="text"
                                                placeholder="{{ __('Text') }}">
                                            <div class="input-group-append">
                                                <button type="button" id="myEditor_icon"
                                                    class="btn btn-outline-secondary"></button>
                                            </div>
                                        </div>
                                        <input type="hidden" name="icon" class="item-menu">
                                        @error('text')
                                            <span class="invalid-feedback d-block">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label for="href">{{ __('URL') }}</label>
                                        <datalist id="hrefList">
                                            @foreach ($hrefs as $href)
                                                <option value="{{ $href->href }}">{{ $href->page_name }}</option>
                                            @endforeach
                                        </datalist>
                                        <input type="text" list="hrefList" class="form-control item-menu" id="href"
                                            name="href" placeholder="{{ __('URL') }}">
                                        @error('href')
                                            <span class="invalid-feedback d-block">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label for="target">{{ __('Target') }}</label>
                                        <select name="target" id="target" class="form-control item-menu">
                                            <option value="_self">{{ __('Self') }}</option>
                                            <option value="_blank">{{ __('Blank') }}</option>
                                            <option value="_top">{{ __('Top') }}</option>
                                        </select>
                                        @error('target')
                                            <span class="invalid-feedback d-block">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label for="title">{{ __('Tool-tip') }}</label>
                                        <input type="text" name="title" class="form-control item-menu" id="title"
                                            placeholder="{{ __('Tool-tip') }}">
                                    </div>
                                </div>
                                <div class="card-footer">
                                    <input type="hidden" name="id" value="">
                                    <input type="hidden" name="category_id" value="{{ $category_id }}">
                                    <button type="submit" class="btn btn-success"><i class="fas fa-plus"></i>
                                        {{ __('Save') }}</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!-- Button trigger modal -->
        <div class='modal fade' id='delete_modal'>
            <div class='modal-dialog modal-dialog-centered' role='document'>
                <div class='modal-content modal-sm'>
                    <div class='modal-header'>
                        <h5 class='modal-title' id='exampleModalLabel'>{{ __('Delete Menu') }}</h5>
                        <button type='button' class='close' data-dismiss='modal' aria-label='Close'>
                            <span aria-hidden='true'>&times;</span>
                        </button>
                    </div>
                    <div class='modal-body text-center'>
                        {{ __('Do you want to delete this menu?') }}
                        <br />

                        <form action="{{ route('admin.menu.item.delete') }}" method="post">
                            @csrf
                            <div class="text-center">
                                <input type="hidden" name="id" id="delete_href">
                                <button type="button" data-dismiss='modal'
                                    class='btn btn-primary'>{{ __('No') }}</button>
                                <button type="submit" class='btn btn-danger'>{{ __('Yes') }}</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('page-script')
    <script src="{{ asset('backend/dynamic-menu/js/nestable-menu.js') }}"></script>
    @include('backend.pages.settings.menu-settings.internal-assets.js.menu-item-js')
@endsection
