@extends('backend.layouts.master-layout')
@section('title', config('app.name', 'laravel') . ' | ' . $title)
@section('page-css')
    @include('backend.pages.settings.page-settings.internal-assets.css.page-settings-css')
@endsection
@section('content')
    <div id="wrapper-content">
        <div class="row">
            <div class="col">
                <nav class="breadcrumb justify-content-sm-start justify-content-center text-center text-light bg-dark ">
                    <a class="breadcrumb-item text-white" href="{{ route('admin.dashboard') }}">{{ __('Home') }}</a>
                    <span class="breadcrumb-item active">{{ __($title) }}</span>
                    <span class="breadcrumb-info" id="time"></span>
                </nav>
            </div>
        </div>
        <!-- Slider -->
        <div class="row">
            <div class="col-12">
                <div class="card card-light bg-white text-light rounded">
                    <div class="card-header bg-dark expand-btn">
                        <div class="col-6">
                            <span class="card-title font-weight-bold">{{ __('Slider') }}</span>
                        </div>
                        <div class="col-6 text-right">
                            <i class="fas fa-chevron-circle-down fa-2x"></i>
                        </div>
                    </div>
                    <form action="" method="post" class="d-none">
                        <input type="hidden" name="page" value="home">
                        <input type="hidden" name="group" value="slider">
                    </form>
                </div>
            </div>
        </div>
        <!-- Place -->
        <div class="row">
            <div class="col-12">
                <div class="card card-light bg-white text-light rounded">
                    <div class="card-header bg-dark expand-btn">
                        <div class="col-6">
                            <span class="card-title font-weight-bold">{{ __('Place') }}</span>
                        </div>
                        <div class="col-6 text-right">
                            <i class="fas fa-chevron-circle-down fa-2x"></i>
                        </div>
                    </div>
                    <form action="" method="post"
                          class="d-none" enctype="multipart/form-data">
                        <input type="hidden" name="page" value="home">
                        <input type="hidden" name="group" value="place">
                    </form>
                </div>
            </div>
        </div>
        <!--  feature -->
        <div class="row">
            <div class="col-12">
                <div class="card card-light bg-white text-light rounded">
                    <div class="card-header bg-dark expand-btn">
                        <div class="col-6">
                            <span class="card-title font-weight-bold">{{ __('Feature') }}</span>
                        </div>
                        <div class="col-6 text-right">
                            <i class="fas fa-chevron-circle-down fa-2x"></i>
                        </div>
                    </div>
                    <form action="{{ route('admin.page-settings.contact-page.store-img') }}" method="post"
                          class="d-none" enctype="multipart/form-data">
                        @csrf
                        <input type="hidden" name="page" value="home">
                        <input type="hidden" name="group" value="feature">
                    </form>
                </div>
            </div>
        </div>
        <!-- Package -->
        <div class="row">
            <div class="col-12">
                <div class="card card-light bg-white text-light rounded">
                    <div class="card-header bg-dark expand-btn">
                        <div class="col-6">
                            <span class="card-title font-weight-bold">{{ __('Special Package') }}</span>
                        </div>
                        <div class="col-6 text-right">
                            <i class="fas fa-chevron-circle-down fa-2x"></i>
                        </div>
                    </div>
                    <form action="" method="post"
                          class="d-none" enctype="multipart/form-data">
                        <input type="hidden" name="page" value="home">
                        <input type="hidden" name="group" value="package">
                    </form>
                </div>
            </div>
        </div>
        <!-- Award -->
        <div class="row">
            <div class="col-12">
                <div class="card card-light bg-white text-light rounded">
                    <div class="card-header bg-dark expand-btn">
                        <div class="col-6">
                            <span class="card-title font-weight-bold">{{ __('Award') }}</span>
                        </div>
                        <div class="col-6 text-right">
                            <i class="fas fa-chevron-circle-down fa-2x"></i>
                        </div>
                    </div>
                    <form action="{{ route('admin.page-settings.contact-page.store-img') }}" method="post"
                            class="d-none" enctype="multipart/form-data">
                        @csrf
                        <input type="hidden" name="page" value="home">
                        <input type="hidden" name="group" value="award">
                    </form>
                </div>
            </div>
        </div>
        <!-- hotel -->
        <div class="row">
            <div class="col-12">
                <div class="card card-light bg-white text-light rounded">
                    <div class="card-header bg-dark expand-btn">
                        <div class="col-6">
                            <span class="card-title font-weight-bold">{{ __('Hotel') }}</span>
                        </div>
                        <div class="col-6 text-right">
                            <i class="fas fa-chevron-circle-down fa-2x"></i>
                        </div>
                    </div>
                    <form action="" method="post"
                          class="d-none" enctype="multipart/form-data">
                        <input type="hidden" name="page" value="home">
                        <input type="hidden" name="group" value="hotel">
                    </form>
                </div>
            </div>
        </div>
        <!-- About -->
        <div class="row">
            <div class="col-12">
                <div class="card card-light bg-white text-light rounded">
                    <div class="card-header bg-dark expand-btn">
                        <div class="col-6">
                            <span class="card-title font-weight-bold">{{ __('About') }}</span>
                        </div>
                        <div class="col-6 text-right">
                            <i class="fas fa-chevron-circle-down fa-2x"></i>
                        </div>
                    </div>
                    <form action="{{ route('admin.page-settings.contact-page.store-img') }}" method="post"
                        class="d-none" enctype="multipart/form-data">
                        @csrf
                        <input type="hidden" name="page" value="home">
                        <input type="hidden" name="group" value="about">
                    </form>
                </div>
            </div>
        </div>
            <!-- gellery -->
            <div class="row">
                <div class="col-12">
                    <div class="card card-light bg-white text-light rounded">
                        <div class="card-header bg-dark expand-btn">
                            <div class="col-6">
                                <span class="card-title font-weight-bold">{{ __('Gallery') }}</span>
                            </div>
                            <div class="col-6 text-right">
                                <i class="fas fa-chevron-circle-down fa-2x"></i>
                            </div>
                        </div>
                        <form action="" method="post" class="d-none">
                            <input type="hidden" name="page" value="home">
                            <input type="hidden" name="group" value="gallery">
                        </form>
                    </div>
                </div>
            </div>
            <!-- Testimonial -->
            <div class="row">
                <div class="col-12">
                    <div class="card card-light bg-white text-light rounded">
                        <div class="card-header bg-dark expand-btn">
                            <div class="col-6">
                                <span class="card-title font-weight-bold">{{ __('Testimonial') }}</span>
                            </div>
                            <div class="col-6 text-right">
                                <i class="fas fa-chevron-circle-down fa-2x"></i>
                            </div>
                        </div>
                        <form action="" method="post" class="d-none">
                            <input type="hidden" name="page" value="home">
                            <input type="hidden" name="group" value="testimonial">
                        </form>
                    </div>
                </div>
            </div>
        <!-- Promotional text -->
        <div class="row">
            <div class="col-12">
                <div class="card card-light bg-white text-light rounded">
                    <div class="card-header bg-dark expand-btn">
                        <div class="col-6">
                            <span class="card-title font-weight-bold">{{ __('Promotional Text') }}</span>
                        </div>
                        <div class="col-6 text-right">
                            <i class="fas fa-chevron-circle-down fa-2x"></i>
                        </div>
                    </div>
                    <form action="{{ route('admin.page-settings.contact-page.store-img') }}" method="post"
                          class="d-none" enctype="multipart/form-data">
                        @csrf
                        <input type="hidden" name="page" value="home">
                        <input type="hidden" name="group" value="promotional">
                    </form>
                </div>
            </div>
        </div>
            <!-- Blog -->
            <div class="row">
                <div class="col-12">
                    <div class="card card-light bg-white text-light rounded">
                        <div class="card-header bg-dark expand-btn">
                            <div class="col-6">
                                <span class="card-title font-weight-bold">{{ __('Blog') }}</span>
                            </div>
                            <div class="col-6 text-right">
                                <i class="fas fa-chevron-circle-down fa-2x"></i>
                            </div>
                        </div>
                        <form action="" method="post" class="d-none">
                            <input type="hidden" name="page" value="home">
                            <input type="hidden" name="group" value="blog">
                        </form>
                    </div>
                </div>
            </div>
    </div>
@endsection
@section('page-script')
    <script src="{{ asset('backend/page-section-settings/script.js') }}"></script>
    @include('backend.layouts.message')
    @include('backend.pages.delete-warning')
@endsection
