@extends('backend.layouts.master-layout')
@section('title', config('app.name', 'laravel').' | '.$title)
@section('page-css')
@endsection
@section('content')
<div id="wrapper-content">
    <div class="row">
        <div class="col">
            <nav class="breadcrumb justify-content-sm-start justify-content-center text-center text-light bg-dark ">
                <a class="breadcrumb-item text-white" href="{{ route('admin.dashboard') }}">{{__('Home')}}</a>
                <span class="breadcrumb-item active">{{__($title)}}</span>
                <span class="breadcrumb-info" id="time"></span>
            </nav>
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card card-dark bg-dark">
                <div class="card-header">
                    <h6 class="card-title">{{__($title)}}</h6>
                </div>
                <div class="card-body ">
                    <form action="{{ route('admin.settings.smtp-save') }}" method="POST" enctype="multipart/form-data" class="wma-form">
                        @csrf
                        <div class="mb-3">
                            <p class="mb-1">{{ __('Mail Driver') }}: </p>
                            <div class="input-group input-group-lg">
                                <input type="text" name="mail_driver" class="form-control @error('mail_driver') is-invalid @enderror" aria-label="Large" aria-describedby="inputGroup-sizing-sm"
                                       placeholder="{{ __('Mail Driver') }}" value="{{ old('mail_driver', env('MAIL_MAILER')) }}">
                            </div>
                            @error('mail_driver')
                            <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <p class="mb-1">{{ __('Mail Host') }}: </p>
                            <div class="input-group input-group-lg">
                                <input type="text" name="mail_host" class="form-control @error('mail_host') is-invalid @enderror" aria-label="Large" aria-describedby="inputGroup-sizing-sm"
                                       placeholder="{{ __('Mail Host') }}" value="{{ old('mail_host', env('MAIL_HOST')) }}">
                            </div>
                            @error('mail_host')
                            <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <p class="mb-1">{{ __('Mail Port') }}: </p>
                            <div class="input-group input-group-lg">
                                <input type="text" name="mail_port" class="form-control @error('mail_port') is-invalid @enderror" aria-label="Large" aria-describedby="inputGroup-sizing-sm"
                                       placeholder="{{ __('Mail Port') }}" value="{{ old('mail_port', env('MAIL_PORT')) }}">
                            </div>
                            @error('mail_port')
                            <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <p class="mb-1">{{ __('Mail User Name') }}: </p>
                            <div class="input-group input-group-lg">
                                <input type="text" name="mail_username" class="form-control @error('mail_username') is-invalid @enderror" aria-label="Large" aria-describedby="inputGroup-sizing-sm"
                                       placeholder="{{ __('Mail User Name') }}" value="{{ old('mail_username', env('MAIL_USERNAME')) }}">
                            </div>
                            @error('mail_username')
                            <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <p class="mb-1">{{ __('Mail Password') }}: </p>
                            <div class="input-group input-group-lg">
                                <input type="password" name="mail_password" class="form-control @error('mail_password') is-invalid @enderror" aria-label="Large" aria-describedby="inputGroup-sizing-sm"
                                       placeholder="{{ __('Mail Password') }}" value="{{ old('mail_password', env('MAIL_PASSWORD')) }}">
                            </div>
                            @error('mail_password')
                            <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <p class="mb-1">{{ __('Mail Encryption') }}: </p>
                            <div class="input-group input-group-lg">
                                <input type="text" name="mail_encryption" class="form-control @error('mail_encryption') is-invalid @enderror" aria-label="Large" aria-describedby="inputGroup-sizing-sm"
                                       placeholder="{{ __('Mail Encryption') }}" value="{{ old('mail_encryption', env('MAIL_ENCRYPTION')) }}">
                            </div>
                            @error('mail_encryption')
                            <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>
                        <div class="mb-3">
                            <p class="mb-1">{{ __('Mail From Address') }}: </p>
                            <div class="input-group input-group-lg">
                                <input type="email" name="mail_from_address" class="form-control @error('mail_from_address') is-invalid @enderror" aria-label="Large" aria-describedby="inputGroup-sizing-sm"
                                       placeholder="{{ __('Mail From Address') }}" value="{{ old('mail_from_address', env('MAIL_FROM_ADDRESS')) }}">
                            </div>
                            @error('mail_from_address')
                            <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="wizard-action text-left">
                            <button class="btn btn-wave-light btn-danger btn-lg" type="submit">{{ __('Submit form') }}</button>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('page-script')
    @include('backend.layouts.message')
@endsection
