@php
$error_page = App\Models\PageSectionSettings::where('name', 'error_404_page')->first();
@endphp
@extends('frontend.layouts.master-layout')
@section('page-css')
@endsection
@section('content')
    <!-- error Section Start -->
    <section class="error-area parallax-bg" @if ($error_page && $error_page->bg_img)
        data-background="{{ $error_page->bg_img }}"
    @else
        data-background="frontend/images/bg/px-1.jpg"
        @endif data-type="parallax"
        data-speed="3">
        <div class="container">
            <div class="row">
                <div class="col-sm-12">
                    <div class="error-page text-center">
                        <h1>{{ $error_page ? $error_page->title : __('404') }}</h1>
                        @if (empty($exception->getMessage()))
                            <p>{{ $error_page ? $error_page->description : __('Page was not Found') }}</p>
                        @else
                            <p>{{ $exception->getMessage() }}</p>
                        @endif
                        <div class="home-page">
                            <a href="{{ route('home') }}"
                                class="btn-theme">{{ $error_page ? $error_page->btn_title : __('Go to Home Page') }}</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- faq Section End -->
@endsection
@section('page-script')
@endsection
