@extends('frontend.layouts.master-layout')
@section('title', config('app.name', 'laravel') . ' | ' . $title)
@section('page-css')
    <!-- DATA TABLES -->
    <link rel="stylesheet"
        href="{{ asset('/backend/assets/plugin/DataTables/1.10.16/css/dataTables.bootstrap4.min.css') }}" />
@endsection

@section('content')

    <section class="inner-area parallax-bg" style="background-image: url({{ asset('frontend/images/bg/px-1.jpg') }});">
        <div class="container">
            <div class="section-content">
                <div class="row">
                    <div class="col-12">
                        <h4>{{ __('Login in ') }}{{ Auth::user()->name }}</h4>
                        <p><a href="{{ route('home') }}">{{ __('Home') }}</a> <a
                                href="{{ route('guest.dashboard') }}">{{ __('User Details') }}</a></p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="latest-hotel-sec pt-85 pb-80">
        <div class="container">
            <div class="row">
                <div class="col-sm-3">
                    @include('frontend.auth.menus.sidebar')
                </div>

                <div class="col-sm-9">
                    <div class="card">
                        <div class="card-body">
                            <table class="table table-bordered data-table">
                                <thead>
                                    <th width="5%">{{ __('SL') }}</th>
                                    <th>{{ __('Package') }}</th>
                                    <th>{{ __('Arrival Time') }}</th>
                                    <th>{{ __('Status') }}</th>
                                    <th width="10%">{{ __('Action') }}</th>
                                </thead>
                                <tbody>

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection

@section('page-script')
    <script src="{{ asset('notification_assets/js/sweetalert.min.js') }}"></script>
    <script src="{{ asset('/backend/assets/plugin/DataTables/1.10.16/js/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('/backend/assets/plugin/DataTables/1.10.16/js/dataTables.bootstrap4.min.js') }}"></script>
    @include('frontend.auth.pages.js.package-datatable')
    @include('frontend.auth.pages.js.delete-warning')
@endsection
