@extends('frontend.layouts.master-layout')
@section('title', config('app.name', 'laravel') . ' | ' . $title)

@push('page-css')

@endpush

@section('content')
    <section class="inner-area parallax-bg" style="background-image: url({{ asset('frontend/images/bg/px-1.jpg') }});">
        <div class="container">
            <div class="section-content">
                <div class="row">
                    <div class="col-12">
                        <h4>{{ __('Login in ') }}{{ Auth::user()->name }}</h4>
                        <p><a href="{{ route('home') }}">{{ __('Home') }}</a> <a
                                href="{{ route('guest.dashboard') }}">{{ __('User Details') }}</a></p>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section class="latest-hotel-sec pt-85 pb-80">
        <div class="container">
            <div class="row">
                <div class="col-sm-3">
                    @include('frontend.auth.menus.sidebar')
                </div>
                <div class="col-sm-9">
                    <div class=" card card-body mb-3">
                        <div class="">
                            <div class="h5">{{ __('Profile Information') }}</div>
                        </div>
                        <form action="{{ route('guest.profile.update.store') }}" method="post"
                            enctype="multipart/form-data" class="wma-form">
                            @csrf
                            <div class="">
                                <div class="row">
                                    <div class="col">
                                        <p class=" font-weight-bold"><label for="name">{{ __('Name') }}:<span class="text-danger">*</span></label>
                                        </p>
                                        <div class="input-group input-group-lg mb-3">
                                            <input type="text" name="name" id="name" value="{{ Auth::user()->name }}"
                                                class="form-control rounded" aria-label="Large"
                                                placeholder="{{ __('Name in English') }}"
                                                aria-describedby="inputGroup-sizing-sm">
                                            <br>
                                            @if ($errors->has('name'))
                                                <span class="text-danger">{{ $errors->first('name') }}</span>
                                            @endif
                                        </div>
                                        <p class="mb-1 font-weight-bold"><label for="email">{{ __('Email') }}:</label>
                                        </p>
                                        <div class="input-group input-group-lg mb-3">
                                            <p class="form-control">{{ Auth::user()->email }}</p>
                                            <br>
                                            @if ($errors->has('email'))
                                                <span class="text-danger">{{ $errors->first('email') }}</span>
                                            @endif
                                        </div>
                                        {{-- about me --}}
                                        <div class="form-group">
                                            <label for="pageContent">
                                                <span
                                                    class="d-block card-title mb-1 font-weight-bold">{{ __('Address :') }}
                                                    <span class="text-danger">*</span>
                                                </span>
                                            </label>
                                            <textarea name="address" id="address" rows="5" class="form-control "
                                                placeholder="{{ __('') }}">{{ Auth::user()->address }}</textarea>
                                            @error('address')
                                                <span class="invalid-feedback d-block">{{ $message }}</span>
                                            @enderror
                                        </div>

                                        <div class="form-group">
                                            <label for="pageContent">
                                                <span
                                                    class="d-block card-title mb-1 font-weight-bold">{{ __('About Me :') }}
                                                </span>
                                            </label>
                                            <textarea name="about_me" id="about_me" rows="5" class="form-control "
                                                      placeholder="{{ __('') }}">{{ Auth::user()->about_me }}</textarea>
                                            @error('about_me')
                                                <span class="invalid-feedback d-block">{{ $message }}</span>
                                            @enderror
                                        </div>
                                        {{-- end about me --}}
                                    </div>
                                </div>
                                <div class="float-right">
                                    <button class="btn btn-wave-light rounded btn-danger btn-lg"
                                        type="submit">{{ __('Save') }}</button>
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="card">
                        <div class="card-body">
                            <div class="">
                                <div class="h5">{{ __('Update Password') }}</div>
                                <p class="">
                                    {{ __('Ensure your account is using a long, random password to stay secure.') }}</p>
                            </div>
                            <form action="{{ route('guest.password-update') }}" method="post" enctype="multipart/form-data"
                                class="wma-form">
                                @csrf
                                <div class="col-12">
                                    <div class="row mt-3">
                                        <div class="col-12">
                                            <p class="mb-1 font-weight-bold text-right"><label
                                                    for="currentPassword">{{ __('Current Password') }}: </label> </p>
                                            <div class="form-group input-group-lg mb-3">
                                                <input type="password" name="current_password" id="currentPassword"
                                                    class="form-control rounded text-right" aria-label="Large"
                                                    aria-describedby="inputGroup-sizing-sm">
    
                                                @error('current_password')
                                                    <p class="text-danger">{{ $message }}</p>
                                                @enderror
                                            </div>
                                            <p class="mb-1 font-weight-bold text-right"><label
                                                    for="password">{{ __('New Password') }}:</label> </p>
                                            <div class="form-group input-group-lg mb-3">
                                                <input type="password" name="password" id="password"
                                                    class="form-control rounded text-right" aria-label="Large"
                                                    aria-describedby="inputGroup-sizing-sm">
                                                @error('password')
                                                    <p class="text-danger">{{ $message }}</p>
                                                @enderror
                                            </div>
                                            <p class="mb-1 font-weight-bold text-right"><label
                                                    for="passwordConfirmation">{{ __('Confirm Password') }}:</label> </p>
                                            <div class="form-group input-group-lg mb-3">
                                                <input type="password" name="password_confirmation" id="passwordConfirmation"
                                                    class="form-control rounded text-right" aria-label="Large"
                                                    aria-describedby="inputGroup-sizing-sm">
                                                @error('password_confirmation')
                                                    <p class="text-danger">{{ $message }}</p>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>
                                    <div class="float-left">
                                        <button class="btn btn-wave-light rounded btn-danger btn-lg"
                                            type="submit">{{ __('Save') }}</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection

@push('page-script')

@endpush
