@extends('frontend.layouts.master-layout')
@section('title', config('app.name', 'laravel') . ' | ' . $title)
@push('page-css')
@endpush
@section('content')

<section class="inner-area parallax-bg"
    style="@if(!empty($pageContent->bg_img))background-image: url({{asset($pageContent->bg_img)}});@else background-image: url({{asset('frontend/images/bg/px-1.jpg')}}); @endif">
    <div class="container">
        <div class="section-content">
            <div class="row">
                <div class="col-12">
                    <h4>{{isset($title)?$title:''}}</h4>
                    <p><a href="{{ route('home') }}">{{ __('Home') }}</a> <a href="#">{{isset($title)?$title:''}}</a>
                    </p>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- SIGN-IN SECTION -->
<div class="container">
    <div class="card card-body col-md-6 offset-md-3 my-sm-4 ">
        <div class="box-account o">
            @if ($pageContent && $pageContent->show)
            <form class="box-account-form" action="{{ route('guest.register.store') }}" method="post">
                @csrf
                <span class="reauth-email"> </span>
                <div class="row">
                    <div class="form-group col-md-6">
                        <label for="floatingInput">{{ __('First name:') }}</label><sup class="text-danger">*</sup>
                        <input class="form-control" type="text" name="name" required
                            placeholder="{{ __('First name') }}" id="name" value="{{ old('name') }}">
                        @error('name')
                        <span class="text-danger">{{ $message }}</span>
                        @enderror
                    </div>

                    <div class="form-group col-md-6">
                        <label for="floatingInput">{{ __('Last name:') }}</label><sup class="text-danger">*</sup>
                        <input class="form-control" type="text" name="surname" required
                            placeholder="{{ __('Last name') }}" id="name" value="{{ old('surname') }}">
                        @error('surname')
                        <span class="text-danger">{{ $message }}</span>
                        @enderror
                    </div>

                </div>

                <div class="form-group">
                    <label for="floatingInput">{{ __('Email address:') }}</label><sup class="text-danger">*</sup>
                    <input class="form-control" type="email" name="email" required placeholder="{{ __('Email') }}"
                        id="email" value="{{ old('email') }}">
                    @error('email')
                    <span class="text-danger">{{ $message }}</span>
                    @enderror
                </div>

                <div class="form-group">
                    <label for="floatingInput">{{ __('Phone number:') }}</label><sup class="text-danger">*</sup>
                    <input class="form-control" type="tel" name="phone" required placeholder="{{ __('Phone') }}"
                        id="phone" value="{{ old('phone') }}">
                    @error('phone')
                    <span class="text-danger">{{ $message }}</span>
                    @enderror
                </div>


                <div class="form-gropu">
                    <label for="floatingInput">{{ __('New password:') }}</label><sup class="text-danger">*</sup>
                    <input class="form-control" type="password" name="password" required
                        placeholder="{{ __('Password') }}" id="password">
                    @error('password')
                    <span class="text-danger">{{ $message }}</span>
                    @enderror
                </div>

                <div class="form-gropu pb-1">
                    <label for="floatingInput">{{ __('Confirm password:') }}</label><sup class="text-danger">*</sup>
                    <input class="form-control" type="password" name="password_confirmation" required
                        placeholder="{{ __('Confirm Password') }}" id="password_confirmation">
                    @error('password_confirmation')
                    <span class="text-danger">{{ $message }}</span>
                    @enderror
                </div>

                <button class="btn-login  btn-lg btn-block btn-wave-light" type="submit">{{ __('Sign Up') }}</button>
            </form>
            @endif
            <div class="mb-2">
                @if (env('ENABLE_GOOGLE_LOGIN') == 'yes')
                <p class="mx-auto text-center">{{ __('OR') }}</p>
                <a href="{{ route('oauth.redirect', OAUTH_TYPE_GOOGLE) }}" class="btn btn-info btn-block text-white"><i
                        class="fa fa-google float-left pl-3 mt-1"></i>
                    {{ __('Login with Google') }}</a>
                @endif
                @if (env('ENABLE_FACEBOOK_LOGIN') == 'yes')
                <a href="{{ route('oauth.redirect', OAUTH_TYPE_FACEBOOK) }}"
                    class="btn btn-danger btn-block text-white"><i class="fa fa-facebook float-left pl-3 mt-1 "></i>
                    {{ __('Login with Facebook') }}</a>
                @endif
            </div>
        </div>
    </div>
</div>
<!-- END SIGN-IN SECTION -->
@endsection

@push('page-script')


@endpush