@extends('frontend.layouts.master-layout')

@section('title', config('app.name', 'laravel') . ' | ' . $title)

@section('page-css')

@endsection

@section('content')
    <!-- Inner Section Start -->
    <section class="inner-area parallax-bg" @if (!empty($pageContent->bg_img))style="background-image: url({{ asset($pageContent->bg_img) }});@else background-image: url({{ asset('frontend/images/bg/px-1.jpg') }});" @endif>
        <div class="container">
            <div class="section-content">
                <div class="row">
                    <div class="col-12">
                        <h4>{{ isset($title) ? clean($title) : '' }}</h4>
                        <p><a href="{{ route('home') }}">{{ __('Home') }}</a>
                            <a>{{ isset($title) ? clean($title) : '' }}</a>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Inner Section End -->

    @if ($about_section)
        <!-- Global Section Start -->
        <section class="global-section over-layer-white pt-80 pb-70">
            <div class="container">
                <div class="row">
                    <div class="col-xl-7 col-lg-12">
                        <div class="global-area">
                            <div class="inner-title">
                                <h2>{{ clean($about_section ? $about_section->title : '') }}</h2>
                                <h3>{{ clean($about_section ? $about_section->sub_title : '') }}</h3>
                                <div class="sec-line"></div>
                            </div>
                            {!! clean($about_section ? $about_section->description : '') !!}
                        </div>
                    </div>
                    <div class="col-xl-5 col-lg-8 col-md-10">
                        <div class="map-area">
                            <img src="{{ $about_section_right ? $about_section_right->fnt_img : '' }}" alt="image">
                        </div>
                        <p class="map-content">
                            {{ clean($about_section_right ? $about_section_right->about_image_phone : '') }}
                        </p>
                    </div>
                </div>
            </div>
        </section>
        <!-- Global Section End -->
    @endif


    @if ($about_feature)
        <!-- Features Section Start -->
        <section class="feature-section over-layer-black pt-85 pb-90" style="@if (!empty($about_feature->bg_img))background-image: url({{ $about_feature->bg_img }});@else background-image: url({{ asset('frontend/images/bg/px-1.jpg') }}); @endif">
            <div class="container">
                <div class="row">
                    <div class="section-title">
                        <h4>{{ clean($about_feature ? $about_feature->title : '') }}</h4>
                        <h2>{{ clean($about_feature ? $about_feature->sub_title : '') }}</h2>
                        {!! clean($about_feature ? $about_feature->description : '') !!}
                    </div>
                </div>
                <div class="row">
                    @foreach ($features as $feature)
                        <div class="col-md-4">
                            <div class="feature-item">
                                <div class="icon-box">
                                    {!! clean($feature ? $feature->icon : '') !!}
                                </div>
                                <div class="content">
                                    <h3>{{ clean($feature ? $feature->title : '') }}</h3>
                                    <p>{{ clean($feature ? $feature->description : '') }}</p>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </section>
        <!-- Feature Section End -->
    @endif


    @if ($about_team_section)
        <!-- Team Section Start -->
        <section class="team-section bg-f8">
            <div class="container">
                <div class="row">
                    <div class="section-title">
                        <h4>{{ clean($about_team_section ? $about_team_section->title : '') }}</h4>
                        <h2>{{ clean($about_team_section ? $about_team_section->sub_title : '') }}</h2>
                        <p>{{ clean($about_team_section ? $about_team_section->description : '') }}</p>
                    </div>
                </div>
                <div class="row">
                    @foreach ($teamMembers as $teamMember)
                        <div class="col-lg-3 col-md-4 col-sm-6">
                            <div class="team-col">
                                <div class="thumb">
                                    {!! imageShow($teamMember->image, __('Team photo')) !!}
                                </div>
                                <div class="content text-center">
                                    <h4><a href="#">{{ clean($teamMember ? $teamMember->name : '') }}</a></h4>
                                    <h5>{{ clean($teamMember ? $teamMember->designation->name : '') }}</h5>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </section>
        <!-- Team Section End -->
    @endif


    <!-- Funfact Section Start -->

    @if ($award_setting)
        <!-- Funfact Section Start -->
        <section class="funfact-section over-layer-black pt-90 pb-60">
            <div class="container">
                <div class="row">
                    <div class="col-lg-6">
                        <div class="video-sec">
                            <h2>{{ clean($award_setting ? $award_setting->title : '') }}</h2>
                            <p>{{ clean($award_setting ? $award_setting->sub_title : '') }}</p>
                            <div class="video-content">
                                {!! imageShow($award_setting->fnt_img, __('Award Image')) !!}
                                @if ($award_setting->youtube_url)
                                    <div class="overlay">
                                        <a href="{{ $award_setting->youtube_url }}" class="popup-youtube"><i
                                                class="ficon fa fa-play-circle"></i></a>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        {!! clean($award_setting ? $award_setting->description : '') !!}
                    </div>
                </div>
            </div>
        </section>
        <!-- Funfact Section End -->
    @endif

    @if ($about_client_section)
        <!-- Testimonials Section Start -->
        <section class="testimonials-section pt-80 pb-80">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="inner-title">
                            <h2>{{ clean($about_client_section ? $about_client_section->title : '') }}</h2>
                            <div class="sec-line mb-40"></div>
                        </div>
                        <div class="testimonials-post testimonials_slide_col_two owl-carousel owl-theme owl-navst st-three">
                            @foreach ($aboutClients as $aboutClient)
                                <div class="testimonials-item">
                                    <div class="thumb">
                                        {!! imageShow($aboutClient->image, __('Client photo')) !!}
                                    </div>
                                    <div class="content">
                                        <h5>{{ clean($aboutClient ? $aboutClient->name : '') }} <small>-
                                                {{ clean($aboutClient ? $aboutClient->designation : '') }}</small></h5>
                                        {!! ratingShow($aboutClient->rating) !!}
                                        <p><i
                                                class="fa fa-quote-left"></i>{{ $aboutClient ? $aboutClient->testimonial : '' }}
                                        </p>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- Testimonials Section End -->
    @endif


    @if ($about_blog_section)
        <!-- Blog Section Start -->
        <section class="blog-section bg-f8 pt-85 pb-55">
            <div class="container">
                <div class="row">
                    <div class="section-title">
                        <h4>{{ clean($about_blog_section ? $about_blog_section->title : '') }}</h4>
                        <h2>{{ clean($about_blog_section ? $about_blog_section->sub_title : '') }}</h2>
                        <p>{{ clean($about_blog_section ? $about_blog_section->description : '') }}</p>
                    </div>
                </div>
                <div class="row">
                    @foreach ($blogs as $blog)
                        <div class="col-md-6 col-lg-4">
                            <div class="blog-post">
                                <div class="thumb">
                                    {!! imageShow($blog->feature_img, __('Blog Image')) !!}
                                    <div class="content">
                                        <h3>{{ $blog ? $blog->title : '' }}</h3>
                                        <div class="meta-box">
                                            <div class="admin-post"> {{ __('Admin, TributeTheme') }} </div>
                                            <div class="inner">
                                                <div class="date">
                                                    <i class="fa fa-calendar-plus-o"></i>
                                                    {{ date('M', strtotime($blog->created_at)) }}
                                                    <b>{{ date('d', strtotime($blog->created_at)) }}</b>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <a href="{{ route('view-single-blog-page', ['slug' => $blog->slug]) }}"
                                    class="read-btn">{{ __('Continue
                                                                                                                                                                                                        Reading') }}
                                    <i class="fa fa-long-arrow-right" aria-hidden="true"></i>
                                </a>
                            </div>
                        </div>
                    @endforeach

                </div>
            </div>
        </section>
        <!-- Blog Section End -->
    @endif


@endsection

@section('page-script')

@endsection
