@extends('frontend.layouts.master-layout')

@section('title', config('app.name', 'laravel') . ' | ' . $title)

@section('page-css')

@endsection

@section('content')
    <!-- Inner Section Start -->
    <section class="inner-area parallax-bg" style="@if (!empty($pageContent->bg_img))background-image: url({{ asset($pageContent->bg_img) }}); @endif">
        <div class="container">
            <div class="section-content">
                <div class="row">
                    <div class="col-12">
                        <h4>{{ isset($title) ? clean($title) : '' }}</h4>
                        <p><a href="{{ route('home') }}">{{ __('Home') }}</a> <a>{{ isset($title) ? clean($title) : '' }}</a></p>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Inner Section End -->

    <!-- Blog Section Start -->
    <section class="blog-section">
        <div class="container">
            <div class="row">
                @foreach ($blogs as $blog)
                    <div class="col-md-6 col-lg-4">
                        <div class="blog-post">
                            <div class="thumb">
                                <a href="{{ route('view-single-blog-page', ['slug' => $blog->slug]) }}">
                                    {!! imageShow($blog->feature_img, __('Blog Image')) !!}
                                </a>
                                <div class="content">
                                    <a href="{{ route('view-single-blog-page', ['slug' => $blog->slug]) }}">
                                        <h3>{{ clean($blog ? $blog->title : '') }}</h3>
                                    </a>
                                    <div class="meta-box">
                                        <div class="admin-post"> {{ (isset($blog->userId)) ? $blog->userId->name : '' }} </div>
                                        <div class="inner">
                                            <div class="date">
                                                <i class="fa fa-calendar-plus-o"></i>
                                                {{ date('M', strtotime($blog->created_at)) }}
                                                <b>{{ date('d', strtotime($blog->created_at)) }}</b>
                                            </div>
                                            <div class="comment">
                                                <i class="fa fa-commenting-o"></i> 8
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <a href="{{ route('view-single-blog-page', ['slug' => $blog->slug]) }}"
                                class="read-btn">{{__('Continue Reading')}}
                                <i class="fa fa-long-arrow-right" aria-hidden="true"></i>
                            </a>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </section>
    <!-- Blog Section End -->

    <section class="text-center pt-0 pb-70">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    {{ $blogs->links('frontend.pagination.index') }}
                </div>
            </div>
        </div>
    </section>

@endsection

@section('page-script')

@endsection
