@extends('frontend.layouts.master-layout')

@section('title', config('app.name', 'laravel') . ' | ' . $title)

@section('page-css')
    <link rel="stylesheet" href="{{ asset('frontend/css/images-grid.css') }}">
    <link rel="stylesheet" href="{{ asset('css/daterangepicker.css') }}">
@endsection

@section('content')
    <!-- Inner Section Start -->
    <section class="inner-area parallax-bg" style="@if (!empty($pageContent->bg_img)) background-image: url({{ asset($pageContent->bg_img) }}); @endif">
        <div class="container">
            <div class="section-content">
                <div class="row">
                    <div class="col-12">
                        <h4>{{ isset($title) ? $title : '' }}</h4>
                        <p><a href="{{ route('home') }}">{{ __('Home') }}</a>
                            <a>{{ isset($title) ? $title : '' }}</a>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Inner Section End -->

    <!-- Contact Section Start -->
    <div class="container mt-3">
        @if (Session::get('message'))
            <div class="alert alert-success">{{ Session::get('message') }}</div>
        @endif
    </div>
    <section class="contact-section pt-5 pb-20">
        <div class="container">
            <div class="row contact-bg">
                <div class="col-md-12 col-lg-4 p-0">
                    <div class="contact-text">
                        <h2>{{ __('We are') }} <span>{{ __('Booking') }}</span></h2>
                        <h4>{{ clean($package ? $package->title:'') }}</h4>
                        <div class="sec-line mb-20"></div>
                        <div class="contact-info">
                            <div class="icon-box">
                                <i class="flaticon-pin-1"></i>
                            </div>
                            <h6>{{ __('Location: ') }} {{ clean($package ? $package->location:'') }}</h6>
                        </div>
                    </div>
                </div>
                <div class="col-md-12 col-lg-8 style-2">
                    <form class="booking-form" method="post" action="{{ route('booking.package.save') }}">
                        @csrf
                        <div class="form-row">
                            <div class="form-group col-md-12 mb-1">
                                <label for="">{{ __('Accommodation') }}</label>
                                <select name="package_sub_price_id" class="form-control mb-0">
                                    @foreach ($package_group_prices as $package_group_price)
                                        <option {{ $package_group_price->id == $group_price->id ? 'selected' : '' }}
                                                value="{{ $package_group_price->id }}">
                                            {{ $package_group_price->group_size .' (' .discountPriceCalculate($package_group_price->tour_price, $discount)['price'] .')' }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('package_sub_price_id')
                                    <span class="invalid-feedback d-block">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group col-md-12 mb-1">
                                <label for="">{{ __('Arrival Time') }}</label>
                                <input type="text" id="arrival_date_time" name="arrival_date_time" class="form-control" />
                                @error('arrival_date_time')
                                    <span class="invalid-feedback d-block">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group col-md-6 mb-1">
                                <label for="">{{ __('First Name') }}</label>
                                <input type="text" name="first_name" value="{{ Auth::user()->name }}" class="form-control mb-1"
                                       value="{{ old('first_name') }}" />
                                @error('first_name')
                                    <span class="invalid-feedback d-block">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group col-md-6 mb-1">
                                <label for="">{{ __('Last Name') }}</label>
                                <input type="text" name="last_name" value="{{ Auth::user()->surname }}" class="form-control mb-1"
                                       value="{{ old('last_name') }}" />
                                @error('last_name')
                                    <span class="invalid-feedback d-block">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group col-md-6 mb-4">
                                <label for="">{{ __('Email') }}</label>
                                <input type="email" name="email" value="{{ Auth::user()->email }}" class="form-control mb-0" placeholder="Email"
                                       value="{{ old('email') }}" />
                                @error('email')
                                    <span class="invalid-feedback d-block">{{ $message }}</span>
                                @enderror
                                <small class="text-mute">{{ __('Confirmation email sent to this address') }}</small>
                            </div>

                            <div class="form-group col-md-12">
                                <div class="contact-textarea text-center">
                                    <button class="btn btn-theme" type="submit" value="Submit Form">{{ __('Reserve') }}</button>
                                </div>
                                <input type="hidden" name="hotel_id" value="{{ $group_price->package_id }}">
                                <input type="hidden" name="discount_id" value="{{ $discount ? $discount->id : '' }}">
                            </div>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </section>
    <!-- Contact Section End -->
@endsection

@section('page-script')
    <script type="text/javascript" src="{{ asset('js/moment.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('js/daterangepicker.js') }}"></script>
    @include('frontend.pages.booking.script')
@endsection
