@extends('frontend.layouts.master-layout')

@section('title', config('app.name', 'laravel') . ' | ' . $title)

@section('page-css')
    <link rel="stylesheet" href="{{ asset('frontend/css/images-grid.css') }}">
    <link rel="stylesheet" href="{{ asset('css/daterangepicker.css') }}">
    <link rel="stylesheet" href="{{ asset('/backend/assets/css/all.min.css') }}" />
    <link rel="stylesheet" href="{{ asset('frontend/css/payment.css') }}">
@endsection

@section('content')
    <!-- Inner Section Start -->
    <section class="inner-area parallax-bg" style="@if (!empty($pageContent->bg_img)) background-image: url({{ asset($pageContent->bg_img) }}); @endif">
        <div class="container">
            <div class="section-content">
                <div class="row">
                    <div class="col-12">
                        <h4>{{ isset($title) ? $title : '' }}</h4>
                        <p><a href="{{ route('home') }}">{{ __('Home') }}</a>
                            <a>{{ isset($title) ? $title : '' }}</a>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Inner Section End -->

    <!-- Contact Section Start -->
    <div class="container mt-3">
        @if (Session::get('message'))
            <div class="alert alert-success">{{ Session::get('message') }}</div>
        @endif
    </div>
    <section class="contact-section pt-5 pb-20">
        <div class="container">
            <div class="checkout-form">
                <div class="checkout-section">
                    <div class="checkout-header">
                        <h3>{{__('Complete Payment')}}</h3>
                    </div>
                    <div class="checkout-table">
                        <div class="ctable-head ct-row">
                            <div class="column">{{__('Description')}}</div>
                            <div class="column">{{__('Amount')}}</div>
                        </div>
                        <div class="ctable-body">
                            <div class="ct-row">
                                <div class="column">
                                    <h5 class="name">{{ $booking->hotel->hotel_name }}</h5>
                                    <p class="desc">{{ __('Location: ') }} {{ $booking->hotel->hotel_location }}</p>
                                </div>
                                <div class="column">
                                    <strong class="amount">{{ discountPriceCalculate($booking->hotelAccommodation->price, $booking->hotel->discount)['price'] }}</strong>
                                    <span class="qty">{{ $booking->hotelAccommodation->accommodation->name }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="ctable-foot ct-row">
                            <div class="column">{{__('Total')}}</div>
                            <div class="column">
                                <strong>{{ discountPriceCalculate($booking->hotelAccommodation->price, $booking->hotel->discount)['price'] }}</strong>
                            </div>
                        </div>
                        <div id="inside-checkout">
                            @if ($booking->status == BOOKING_STATUS_CONFIRM)
                                <div class="alert alert-info mt-5">
                                    <strong>{{__('Notice!')}}</strong> {{__('Your payment was processed successfully.')}}
                                    <div>{{__('Package Booking confirmed. Package authority will review your booking and give
                                        you confirmation.')}}</div>
                                </div>
                            @endif
                        </div>
                    </div>
                    <div class="checkout-footer">
                        <div class="square">

                        </div>
                        <div class="text">
                            {{__('Please, pay the amount by the methods dispayed on the right.')}}
                        </div>
                    </div>
                </div>
                <div class="payment-section">
                    <div class="payment-option {{ $paypal->is_default == 1 ? 'active' : '' }}">
                        <div class="option-head" id="method1">
                            <div class="arrow">
                                <i class="fa fa-chevron-right"></i>
                            </div>
                            <div class="text">
                                <h4>{{__('PayPal')}}</h4>
                                <p class="mb-0">{{__('Pay with PayPal Payment System')}}</p>
                            </div>
                        </div>
                        <div class="option-body" {{ $paypal->is_default == 1 ? 'style="disblay: block"' : 'style="display: none"' }}>
                            <div class="method_container mt-3" id="method_container1">
                                @if ($booking->status != BOOKING_STATUS_CONFIRM)
                                    <div class="loading text-center pt-3" style="display: none">
                                        <div class="spinner py-3">
                                            <i class="fa fa-circle-o-notch fa-spin fa-3x fa-fw"></i>
                                            <span class="sr-only">{{__('Loading...')}}</span>
                                        </div>
                                    </div>
                                    <div id="paypal_container"></div>
                                @else
                                    <div class="alert alert-info text-center">{{__('Payment is already completed')}}</div>
                                @endif
                            </div>
                        </div>
                    </div>
                    <div class="payment-option {{ $stripe->is_default == 1 ? 'active' : '' }}">
                        <div class="option-head" id="method2">
                            <div class="arrow">
                                <i class="fa fa-chevron-right"></i>
                            </div>
                            <div class="text">
                                <h4>{{__('Credit / Debit Card')}}</h4>
                                <p class="mb-0">{{__('Pay via Credit / Debit Card')}}</p>
                            </div>
                        </div>
                        <div class="option-body" {{ $stripe->is_default == 1 ? 'style="disblay: block"' : 'style="display: none"' }}>
                            <div class="method_container mt-3" id="method_container2">
                                @if ($booking->status != BOOKING_STATUS_CONFIRM)
                                    <div class="loading text-center pt-3" style="display: none">
                                        <div class="spinner py-3">
                                            <i class="fa fa-circle-o-notch fa-spin fa-3x fa-fw"></i>
                                            <span class="sr-only">{{__('Loading...')}}</span>
                                        </div>
                                    </div>
                                    <div id="stripe_container" class="mb-3 mt-2">
                                        <form method="POST" action="{{ route('stripe.capture') }}" class="booking-form my-3" id="stripe_card_form"> @csrf
                                            <input type="hidden" name="payment_method" class="stripe_payment_method" id="stripe_payment_method">
                                            <div class="form-row">
                                                <div class="form-group col-md-9">
                                                    <label for="card_number">{{__('Card Number')}}</label>
                                                    <div id="card_number"></div>
                                                </div>
                                                <div class="form-group col-md-3">
                                                    <label for="card_cvc">{{__('CVC')}}</label>
                                                    <div id="card_cvc"></div>
                                                </div>
                                                <div class="form-group col-md-8">
                                                    <label for="card_cvc">{{__('Name on Card')}}</label>
                                                    <input class="StripeElement w-100 mb-3" name="card_holder_name" placeholder="{{__('Cardholder Name')}}" required id="stripe_card_holder_name" autocomplete="off">
                                                </div>
                                                <div class="form-group col-md-4">
                                                    <label for="card_expiry">{{__('Expiration date')}}</label>
                                                    <div id="card_expiry"></div>
                                                </div>
                                                <div class="form-group col-md-12">
                                                    <div class="text-center text-danger" id="card_errors"></div>
                                                </div>
                                                <div class="form-group col-md-12">
                                                    <div class="contact-textarea text-center">
                                                        <button class="btn btn-theme" type="submit" id="stripe_pay" value="Submit Form">{{ __('Pay Now') }}</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                @else
                                    <div class="alert alert-info text-center">{{__('Payment is already completed')}}</div>
                                @endif
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Contact Section End -->
@endsection

@section('page-script')
    <script type="text/javascript" src="{{ asset('js/moment.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('js/daterangepicker.js') }}"></script>
    <script src="{{ asset('frontend/vendor/axios.min.js') }}"></script>
    <script src="{{ asset('notification_assets/js/sweetalert.min.js') }}"></script>
    <script>const PAYABLE_AMOUNT = parseFloat("{{ discountPriceCalculate($booking->hotelAccommodation->price, $booking->hotel->discount, false)['price'] }}"); </script>
        @foreach ($methods as $method)
            @if ($method->method_type == PAYPAL_PAYMENT)
                @include('frontend.scripts.paypal-js') @endif
            @if ($method->method_type == STRIPE_PAYMENT)
                @include('frontend.scripts.stripe-js')
            @endif
        @endforeach
        <script src="{{ asset('frontend/js/payment.js') }}"></script>
        <script defer>
            @if ($paypal->is_default == 1)
                $("#method1").parent().find(".option-body").show();
            @elseif ($stripe->is_default == 1)
                $("#method2").parent().find(".option-body").show();
            @endif
            @if ($booking->status != BOOKING_STATUS_CONFIRM)
                @if ($paypal->is_default == 1)
                    loadPayPalButton();
                @elseif ($stripe->is_default == 1)
                    loadStripeCardForm();
                @endif
            @endif
        </script>
@endsection
