<div class="mt-3" id="paymentSection">
    <div class="overlay" style="display: none;">
        <i class="fa fa-circle-o-notch fa-spin fa-3x fa-fw"></i>
    </div>
    <div class="h5 text-center">{{ __('Select Payment Method') }}</div>
    <div class="text-dark d-flex justify-content-center">
        @foreach ($methods as $method)
            <div>
                <input type="radio" id="option{{ ucfirst(strtolower($method->method_type)) }}" name="payment_method"> {{-- $method->is_default==1?'checked':'' --}}
                <label for="option{{ ucfirst(strtolower($method->method_type)) }}">
                    @if ($method->method_type == PAYPAL_PAYMENT)
                        {{-- <i class="fa fa-cc-paypal"></i> --}}
                        <img src="{{ asset('frontend/images/paypal.png') }}" alt="{{ PAYPAL_PAYMENT }}">
                    @endif
                    @if ($method->method_type == STRIPE_PAYMENT)
                        <img src="{{ asset('frontend/images/credit-card.png') }}" alt="{{ STRIPE_PAYMENT }}">
                        {{-- <i class="fa fa-credit-card-alt"></i> --}}
                    @endif
                    <span>{{ $method->name }}</span>
                </label>
            </div>
        @endforeach
    </div>
    <div id="method_container" class="mt-2">
        <div class="loading text-center" style="display: none">
            <div class="spinner py-3">
                <i class="fa fa-circle-o-notch fa-spin fa-3x fa-fw"></i>
                <span class="sr-only">{{__('Loading...')}}</span>
            </div>
        </div>
        <div id="paypal_container"></div>
        <div id="stripe_container" class="mb-3 mt-2">
            <form method="POST" action="{{ route('stripe.capture') }}" class="booking-form my-3" id="stripe_card_form"> @csrf
                <input type="hidden" name="payment_method" class="stripe_payment_method" id="stripe_payment_method">
                <div class="form-row">
                    <div class="form-group col-md-4">
                        <input class="StripeElement w-100 mb-3" name="card_holder_name" placeholder="Card Holder Name" required id="stripe_card_holder_name">
                    </div>
                    <div class="form-group col-md-8" id="card_element"></div>
                    <div class="col-md-12">
                        <div id="card_errors" role="alert" class="text-danger text-center"></div>
                    </div>
                    <div class="form-group col-md-12 mt-3">
                        <div class="contact-textarea text-center">
                            <button class="btn btn-theme" type="submit" id="stripe_pay" value="Submit Form">{{ __('Pay Now') }}</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
