@extends('frontend.layouts.master-layout')

@section('title', config('app.name', 'laravel') . ' | ' . $title)

@section('page-css')
<link rel="stylesheet" href="{{ asset('frontend/nouislider/dist/nouislider.min.css') }}">
@endsection

@section('content')
    <!-- Inner Section Start -->
    <section class="inner-area parallax-bg" style="@if (!empty($page_header->bg_img))background-image: url({{ $page_header->bg_img }});@else background-image: url({{ asset('frontend/images/bg/px-1.jpg') }}); @endif" data-type="parallax" data-speed="3">
        <div class="container">
            <div class="section-content">
                <div class="row">
                    <div class="col-12">
                        <h4>{{ isset($title) ? clean($title) : '' }}</h4>
                        <p><a href="{{ route('home') }}">{{ __('Home') }}</a>
                            <a>{{ isset($title) ? clean($title) : '' }}</a>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Inner Section End -->

    <!-- Special Packages Section Start -->
    <section class="special-packages-sec pt-4 pb-60">
        <div class="container">
            <div class="list-size">
                <div class="row">
                    <div class="col-sm-3">
                        <div class="card mb-4">
                            <div class="card-body">
                                <form id="data_form" method="GET">
                                    @csrf
                                    <input type="hidden" name="page" id="page" value="1">
                                    <div class="form-group">
                                        <label for="">{{ __('Place') }}</label>
                                        <select name="place_id" class="form-control">
                                            <option value="">{{ __('Select') }}</option>
                                            @foreach ($places as $place)
                                                <option {{ (!empty($place_id) && $place_id == $place->id) ? 'selected' : '' }} value="{{ $place->id }}">{{ $place->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="">{{ __('Category') }}</label>
                                        <select name="category_id" class="form-control">
                                            <option value="">{{ __('Select') }}</option>
                                            @foreach ($package_categories as $package_category)
                                                <option {{ (!empty($category_id) && $category_id == $package_category->id) ? 'selected' : '' }} value="{{ $package_category->id }}">{{ $package_category->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                    {{-- <div class="form-group">
                                        <label for="">{{ __('Price Range') }} ({{$package_min}} - <span id="price_max">{{ $package_max }}</span>)</label>
                                        <input type="range" name="price_range" id="price_range" class="form-control"
                                            min="{{ $package_min }}" max="{{ $package_max }}" value="{{ $price_range }}" step="1"/>
                                    </div> --}}
                                    <div class="form-group">
                                        <label for="">{{ __('Price') }}</label>
                                        <div id="steps-slider" class="mt-1"></div>
                                        <input type="hidden" id="min_price" name="min_price" value="{{ $min_price }}" />
                                        <input type="hidden" id="max_price" name="max_price" value="{{ $max_price }}" />
                                        <div class="d-flex justify-content-between mt-1">
                                            <span id="min_price_show"></span>
                                            <span id="max_price_show"></span>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-9" id="data_html">
                        {!! $list_view !!}
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Special Packages Section End -->

    @if ($left_package || $right_package_img)
        <!-- Global Section Start -->
        <section class="global-section over-layer-white pt-80 pb-70">
            <div class="container">
                <div class="row">
                    @if ($left_package)
                        <div class="col-xl-7 col-lg-12">
                            <div class="global-area">
                                <div class="inner-title">
                                    <h2>{{ clean($left_package ? $left_package->title : '') }}</h2>
                                    <h3>{{ clean($left_package ? $left_package->sub_title : '') }}</h3>
                                    <div class="sec-line"></div>
                                </div>
                                {!! clean($left_package ? $left_package->description : '') !!}
                            </div>
                        </div>
                    @endif
                    @if ($right_package_img)
                        <div class="col-xl-5 col-lg-8 col-md-10">
                            @if ($right_package_img && $right_package_img->fnt_img)
                                <div class="map-area">
                                    {!! imageShow($right_package_img->fnt_img, __('Image')) !!}
                                </div>
                            @endif
                            <p class="map-content">
                                {{ clean($right_package_img ? $right_package_img->about_image_phone : '') }}</p>
                        </div>
                    @endif
                </div>
            </div>
        </section>
        <!-- Global Section End -->
    @endif

    @if ($testimonial_setting)
        <!-- Testimonials Section Start -->
        <section class="testimonials-section pt-80 pb-80">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="inner-title mt-25">
                            <h2>{{ clean($testimonial_setting ? $testimonial_setting->title : '') }}</h2>
                            <div class="sec-line mb-40"></div>
                        </div>
                        <div class="testimonials-post testimonials_slide owl-carousel owl-theme owl-navst st-three">
                            @foreach ($testimonials as $testimonial)
                                <div class="testimonials-item">
                                    <div class="thumb">
                                        {!! imageShow($testimonial->image, __('Testimonial')) !!}
                                    </div>
                                    <div class="content">
                                        <h5>{{ clean($testimonial ? $testimonial->name : '') }} <small>-
                                                {{ clean($testimonial ? $testimonial->designation : '') }}</small></h5>
                                        {!! ratingShow($testimonial->rating) !!}
                                        <p><i class="fa fa-quote-left"></i>
                                            {{ clean($testimonial ? $testimonial->testimonial : '') }}
                                        </p>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                        <div class="clearfix"></div>
                    </div>
                </div>
            </div>
        </section>
        <!-- Testimonials Section End -->
    @endif

    @include('frontend.pages.packages.map-image-modal')
@endsection

@section('page-script')
    @include('frontend.pages.packages.script')
    @include('frontend.scripts.package-map-script')
@endsection
