@if ($packages->count())
    <div class="row grid-mb">
        @foreach ($packages as $package)
            @php
                $discount = $package->discount ? $package->discount->discount : null;

                $group_size = 0;
                $subprices = $package->subprice;
                if ($subprices) {
                    $group_size = $subprices->max('group_size');
                }

                $package_images = $package->images;
                $route = route('package.details', $package->id);
            @endphp
            <div class="col-xl-6 col-lg-6 col-md-6">
                <div class="special-packages">
                    <div class="thumb">
                        @if (count($package_images))
                        <a href="{{ $route }}">
                            {!! imageShow($package_images[0]->images, __('Tour Image'), '') !!}
                        </a>
                        @endif

                        @if ($discount)
                            <div class="offer-price"> {{ __('Off') }}
                                {{ discountPriceShow($discount) }}
                            </div>
                        @endif
                        <div class="post-title-box">
                            <div class="price-box">
                                <h5>{{ currencyFormat($package->price) }}
                                </h5>
                                <h6>{{ __('Starts From') }}</h6>
                            </div>
                            <div class="title-box">
                                <a href="{{ $route }}">
                                    <h4>{{ Str::limit(clean($package?$package->title:'', 50)) }}</h4>
                                </a>
                                <h3>{{ clean($package?$package->location:'') }}</h3>
                            </div>
                        </div>
                    </div>
                    <div class="content">
                        <ul class="info">
                            <li><a href="#"><i class="fa fa-calendar"></i>{{ $package->day }}
                                    {{ __('Days') }}</a></li>
                            <li><a href="#"><i
                                        class="fa fa-user"></i>{{ $group_size }}</a>
                            </li>
                            @if ($package->tour_map_image)
                                <li><a class="package_map" href="#package_map_modal" data-toggle="modal"
                                        data-name="{{ $package->title }}"
                                        data-image="{{ imageShow($package->tour_map_image, 'Package Image') }}"><i
                                            class="fa fa-map-marker"></i>{{ __('View Map Image') }}</a>
                                </li>
                            @endif
                        </ul>
                        <p>{{ clean(Str::limit($package->description,150)) }}</p>
                        <div class="small-hotel">
                            <div class="thumb">
                                @if (count($package_images))
                                    @foreach ($package_images as $image)
                                        {!! imageShow($image->images, __('Tour Image'), '') !!}&nbsp;
                                    @endforeach
                                @endif
                            </div>
                        </div>
                        <h5 class="share-btn"><i class="fa fa-share-alt" data-toggle="dropdown"
                                aria-expanded="false"></i>
                            <div class="dropdown-menu">
                                @include('frontend.share-link',['route'=>$route])
                            </div>
                        </h5>
                        <a class="btn-theme"
                            href="{{ $route }}">{{ __('View Details') }}</a>
                    </div>
                </div>
            </div>
        @endforeach
    </div>

    <div class="row">
        <div class="col-md-12">
            @if ($packages instanceof \Illuminate\Pagination\LengthAwarePaginator)
                {{ $packages->render('frontend.pagination.index', ['place_id' => $place_id, 'category_id' => $category_id, 'min_price' => $min_price, 'max_price' => $max_price]) }}
            @endif
        </div>
    </div>
@else
    <div class="alert alert-warning text-center">
        <i class="fa fa-search fa-5x mb-3" aria-hidden="true"></i>
        <h4>{{ __('No hotel found') }}</h4>
    </div>
@endif
