@extends('frontend.layouts.master-layout')

@section('title', config('app.name', 'laravel') . ' | ' . $title)

@section('page-css')

@endsection

@section('content')
    <!-- Inner Section Start -->
    <section class="inner-area parallax-bg" style="@if(!empty($pageContent->bg_img))background-image: url({{$pageContent->bg_img}});@else background-image: url({{asset('frontend/images/bg/px-1.jpg')}}); @endif">
        <div class="container">
            <div class="section-content">
                <div class="row">
                    <div class="col-12">
                        <h4>{{isset($title)?$title:''}}</h4>
                        <p><a href="{{route('home')}}">{{__('Home')}}</a> <a>{{isset($title)?$title:''}}</a></p>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Inner Section End -->

    <!-- team Section Start -->
    <section class="team-section">
        <div class="container">
            <div class="row">
                @foreach($teamMembers as $teamMember)
                <div class="col-lg-3 col-md-4 col-sm-6">
                    <div class="team-col">
                        <div class="thumb">
                            {!! imageShow($teamMember->image, __('Team Photo')) !!}
                        </div>
                        <div class="content text-center">
                            <h4><a href="{{route('single-team',$teamMember->id)}}">{{clean($teamMember?$teamMember->name:'')}}</a></h4>
                            <h5>{{clean($teamMember?$teamMember->designation->name:'')}}</h5>
                        </div>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </section>
    <!-- team Section End -->

    <section class="text-center pt-0 pb-70">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    @if (count($teamMembers))
                        {{ $teamMembers->links('frontend.pagination.index') }}
                    @endif
                </div>
            </div>
        </div>
    </section>

@endsection

@section('page-script')

@endsection
