@if ($paginator->hasPages())
<div class="page-link-item text-center pt-30 pb-20">
    <ul>

        @if ($paginator->onFirstPage())
            <li class="disabled"><a class="flaticon-left-arrow-1"></a></li>
        @else
            <li><a data-page="{{ $paginator->currentPage() - 1 }}" href="{{ $paginator->previousPageUrl() }}" rel="prev"><i class="fa fa-angle-left"></i></a></li>
        @endif


        @foreach ($elements as $element)

            @if (is_string($element))
                <li class="disabled"><span>{{ $element }}</span></li>
            @endif


            @if (is_array($element))
                @foreach ($element as $page => $url)
                    @if ($page == $paginator->currentPage())
                        <li><a data-page="{{ $page }}" class="active">{{ $page }}</a></li>
                    @else
                        <li><a data-page="{{ $page }}" href="{{ $url }}">{{ $page }}</a></li>
                    @endif
                @endforeach
            @endif
        @endforeach

        @if ($paginator->hasMorePages())
            <li><a data-page="{{ $paginator->currentPage() + 1 }}" href="{{ $paginator->nextPageUrl() }}" rel="next"><i class="fa fa-angle-right"></i></a></li>
        @else
            <li class="disabled"><a class="flaticon-right-arrow-1"></a></li>
        @endif
    </ul>
</div>
@endif
