<?php
use App\Http\Controllers\AuthController;
use App\Http\Controllers\OAuthController;
use Illuminate\Support\Facades\Route;

Route::get('/login', [AuthController::class, 'guestLoginPage'])->name('login');
Route::get('/register', [AuthController::class, 'guestRegisterStore'])->name('register');


Route::get('admin/login', [AuthController::class, 'adminLogin'])->name('admin.login');
Route::post('admin/post/login', [AuthController::class, 'adminPostLogin'])->name('admin.post.login');

// oauth route (google and facebook)
Route::get('/auth/{type}/redirect', [OAuthController::class, 'oauthRedirect'])->name('oauth.redirect');
Route::get('/auth/{type}/callback', [OAuthController::class, 'oauthCallBack']);