<?php

use App\Http\Controllers\AuthController;
use App\Http\Controllers\GuestViewControllers\UserController;
use App\Http\Controllers\PaypalController;
use App\Http\Controllers\StripeController;
use Illuminate\Support\Facades\Route;

Route::group(['prefix' => 'user', 'as' => 'guest.'], function () {
    Route::get('/login', [AuthController::class, 'guestLoginPage'])->name('login');
    Route::get('/register', [AuthController::class, 'guestRegisterPage'])->name('register');
    Route::post('/register', [AuthController::class, 'guestRegisterStore'])->name('register.store');
    Route::post('/post/login', [AuthController::class, 'guestLoginAuthentication'])->name('post.login');
    Route::get('/forget-password', [AuthController::class, 'guestForgetPassword'])->name('forget.password');
    Route::post('/email-password', [AuthController::class, 'guestEmailPassword'])->name('email.password');
    Route::get('/reset-password/{token}', [AuthController::class, 'guestResetPassword'])->name('reset.password');
    Route::post('/password-reset', [AuthController::class, 'guestPasswordReset'])->name('password.reset');
    Route::get('/email-verify/{token}', [AuthController::class, 'guestEmailVerify'])->name('email.verify');
});

Route::group(['middleware' => 'guest_user'], function () {
    Route::get('/user-dashboard', [UserController::class, 'guestDashboard'])->name('guest.dashboard');
    Route::get('/user-profile-update', [UserController::class, 'guestProfileUpdate'])->name('guest.profile.update');
    Route::post('/user-profile-update-store', [UserController::class, 'guestProfileUpdateStore'])->name('guest.profile.update.store');
    Route::post('/user-profile-image-update', [UserController::class, 'guestProfileImageUpdate'])->name('guest.profile.image.update');
    Route::post('/user-password-update', [UserController::class, 'guestPasswordUpdate'])->name('guest.password-update');
    Route::get('/user-hotel-order', [UserController::class, 'guestHotelOrder'])->name('guest.hotel.order');
    Route::delete('/user-hotel-order-destroy/{id}', [UserController::class, 'guestHotelOrderDelete'])->name('guest.hotel.order.destroy');

    Route::get('/user-package-order', [UserController::class, 'guestPackageOrder'])->name('guest.package.order');
    Route::delete('/user-package-order-destroy/{id}', [UserController::class, 'guestPackageOrderDelete'])->name('guest.package.order.destroy');
    Route::get('/logout', [UserController::class, 'guestLogout'])->name('guest.logout');
});

Route::prefix('ajax')->group(function () {
    Route::post('paypal/order-success', [PaypalController::class, 'orderSuccess'])->name('paypal.success');

    Route::post('stripe/setup-intent', function () {
        $stripe = new \Stripe\StripeClient(paymentMethod(STRIPE_PAYMENT)->secret_key);
        $setupIntent = $stripe->setupIntents->create();
        return $setupIntent;
    });

    Route::post('stripe/capture-payment', [StripeController::class, 'capturePayment'])->name('stripe.capture');
    Route::post('stripe/success-payment', [StripeController::class, 'paymentSuccess'])->name('stripe.success');
});
