
<?php $__env->startSection('title', config('app.name', 'laravel') . ' | ' . $title); ?>
<?php $__env->startSection('page-css'); ?>
    <link href="<?php echo e(asset('backend/assets/plugin/select2/select2.min.css')); ?>" rel="stylesheet" />
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div id="wrapper-content">
        <div class="row">
            <div class="col">
                <nav class="breadcrumb justify-content-sm-start justify-content-center text-center text-light bg-dark ">
                    <a class="breadcrumb-item text-white" href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Home')); ?></a>
                    <a class="breadcrumb-item text-white" href="<?php echo e(route('admin.hotel.index')); ?>"><?php echo e(__('Hotel')); ?></a>
                    <span class="breadcrumb-item active"><?php echo e(__($title)); ?></span>
                    <span class="breadcrumb-info" id="time"></span>
                </nav>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card card-dark bg-dark">
                    <div class="card-header d-block">
                        <?php if(count($hotels)): ?>
                            <h6 class="card-title"><?php echo e(__('Hotel Accommodation')); ?></h6>
                        <?php else: ?>
                            <h6 class="card-title"><?php echo e(__('Hotel Name:')); ?>

                                <?php echo e(isset($hotel) ? $hotel->hotel_name : ''); ?></h6>
                        <?php endif; ?>
                    </div>
                    <?php if(count($list_hotel_accommodations)): ?>
                        <?php echo $__env->make('backend.pages.hotel.hotel-accommodation.list',['hotel_accommodations'=>$list_hotel_accommodations], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                    <form
                        action="<?php echo e($hotel_accommodation ? route('admin.hotel-accommodation.update', $hotel_accommodation->id) : route('admin.hotel-accommodation.store')); ?>"
                        method="post" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <?php if($hotel_accommodation): ?>
                            <?php echo method_field('PATCH'); ?>
                        <?php endif; ?>
                        <div class="card-body" id="accommodation_html">
                            <?php echo $__env->make('backend.pages.hotel.hotel-accommodation.include',
                            ['accommodation'=>$accommodations,'facilities'=>$facilities,'hotel'=>$hotel,'hotels'=>$hotels], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                        <div class="card-footer">
                            <div class="wizard-action text-left">
                                <button class="btn btn-wave-light btn-danger btn-lg"
                                    type="submit"><?php echo e(__('Submit & Add More')); ?></button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <form action="<?php echo e(route('admin.hotel-accommodation.image.destroy')); ?>" method="post" id="deleteForm"
        class="d-none">
    </form>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('page-script'); ?>
    <script src="<?php echo e(asset('backend/assets/plugin/select2/select2.min.js')); ?>"></script>
    <?php echo $__env->make('backend.pages.hotel.hotel-accommodation.internal-assets.js.page-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('backend.pages.hotel.hotel-accommodation.internal-assets.js.delete-warning', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('backend.layouts.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.master-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\php 8.2 projects\htdocs\touranCodester\resources\views/backend/pages/hotel/hotel-accommodation/form.blade.php ENDPATH**/ ?>