<div class="form-row">
    <?php if($hotel): ?>
        <input type="hidden" name="hotel_id" value="<?php echo e($hotel->id); ?>" />
    <?php endif; ?>
    <?php if(count($hotels)): ?>
        <div class="col-sm-12">
            <div class="form-group">
                <p class="mb-1 font-weight-bold"><?php echo e(__('Hotel')); ?></p>
                <select name="hotel_id" class="form-control single_select">
                    <option value=""><?php echo e(__('Select')); ?></option>
                    <?php $__currentLoopData = $hotels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hotel_i): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($hotel_i->id); ?>"><?php echo e($hotel_i->hotel_name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
        </div>
    <?php endif; ?>
    <div class="col-sm-12">
        <div class="form-group">
            <p class="mb-1 font-weight-bold"><?php echo e(__('Accommodation:')); ?>

                <?php echo e($hotel_accommodation ? $hotel_accommodation->accommodation->name : ''); ?></p>
            <?php if(!$hotel_accommodation): ?>
                <select name="accommodation_id" class="form-control">
                    <option value=""><?php echo e(__('Select')); ?></option>
                    <?php $__currentLoopData = $accommodations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $accommodation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $select_accommodation_id = ($hotel_accommodation && $hotel_accommodation->accommodation_id == $accommodation->id) || old('accommodation_id') == $accommodation->id ? 'selected' : '';
                        ?>
                        <option <?php echo e($select_accommodation_id); ?> value="<?php echo e($accommodation->id); ?>">
                            <?php echo e($accommodation->name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <?php $__errorArgs = ['accommodation_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <span class="invalid-feedback d-block"><?php echo e($message); ?></span>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            <?php else: ?>
                <input type="hidden" name="accommodation_id" value="<?php echo e($hotel_accommodation->accommodation_id); ?>">
                <input type="hidden" name="id" value="<?php echo e($hotel_accommodation->id); ?>">
            <?php endif; ?>
        </div>
    </div>
    <div class="col-sm-3">
        <div class="form-group">
            <p class="mb-1 font-weight-bold"><?php echo e(__('Number of Rooms:')); ?></p>
            <input type="number" class="form-control" name="no_of_room"
                value="<?php echo e($hotel_accommodation ? $hotel_accommodation->no_of_room : old('no_of_room')); ?>" />
            <?php $__errorArgs = ['no_of_room'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <span class="invalid-feedback d-block"><?php echo e($message); ?></span>
            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>
    </div>
    <div class="col-sm-3">
        <div class="form-group">
            <p class="mb-1 font-weight-bold"><?php echo e(__('Price:')); ?></p>
            <input type="number" class="form-control" name="price"
                value="<?php echo e($hotel_accommodation ? $hotel_accommodation->price : old('price')); ?>" />
            <?php $__errorArgs = ['price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <span class="invalid-feedback d-block"><?php echo e($message); ?></span>
            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>
    </div>
    <div class="col-sm-3">
        <div class="form-group">
            <p class="mb-1 font-weight-bold"><?php echo e(__('No of Adult:')); ?></p>
            <div class="input-group">
                <select name="no_of_adult" class="form-control">
                    <option value=""><?php echo e(__('Select')); ?></option>
                    <?php for($i = 1; $i <= 10; $i++): ?>
                        <option
                            <?php echo e($hotel_accommodation && $hotel_accommodation->no_of_adult == $i ? 'selected' : ''); ?>

                            value="<?php echo e($i); ?>"><?php echo e($i); ?></option>
                    <?php endfor; ?>
                </select>
                <span class="input-group-text" id="basic-addon2"><?php echo e(__('Person')); ?></span>
            </div>
            <?php $__errorArgs = ['no_of_guest'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <span class="invalid-feedback d-block"><?php echo e($message); ?></span>
            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>
    </div>
    <div class="col-sm-3">
        <div class="form-group">
            <p class="mb-1 font-weight-bold"><?php echo e(__('No of Children:')); ?></p>
            <div class="input-group">
                <select name="no_of_children" class="form-control">
                    <option value=""><?php echo e(__('Select')); ?></option>
                    <?php for($i = 1; $i <= 10; $i++): ?>
                        <option
                            <?php echo e($hotel_accommodation && $hotel_accommodation->no_of_children == $i ? 'selected' : ''); ?>

                            value="<?php echo e($i); ?>"><?php echo e($i); ?></option>
                    <?php endfor; ?>
                </select>
                <span class="input-group-text" id="basic-addon2"><?php echo e(__('Person')); ?></span>
            </div>
            <?php $__errorArgs = ['no_of_guest'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <span class="invalid-feedback d-block"><?php echo e($message); ?></span>
            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>
    </div>
    <div class="col-sm-3">
        <div class="form-group">
            <p class="mb-1 font-weight-bold"><?php echo e(__('Room Size:')); ?></p>
            <div class="input-group">
                <input type="number" class="form-control" name="room_size"
                    value="<?php echo e($hotel_accommodation ? $hotel_accommodation->room_size : old('room_size')); ?>" />
                <span class="input-group-text" id="basic-addon2"><?php echo e(__('m')); ?><sup>2</sup></span>
            </div>
            <?php $__errorArgs = ['room_size'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <span class="invalid-feedback d-block"><?php echo e($message); ?></span>
            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>
    </div>
    <div class="col-sm-3">
        <div class="form-group">
            <p class="mb-1 font-weight-bold"><?php echo e(__('Facilities')); ?></p>
            <select class="form-control form-control-lg multi_select" name="facilities[]" multiple="multiple">
                <?php $__currentLoopData = $facilities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $facility): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option <?php echo e(in_array($facility->id, $hotel_accommodation_facilities) ? 'selected' : ''); ?>

                        value="<?php echo e($facility->id); ?>"><?php echo e($facility->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
            <?php $__errorArgs = ['facilities'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <span class="invalid-feedback d-block"><?php echo e($message); ?></span>
            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>
    </div>
    <div class="col-sm-3">
        <div class="form-group">
            <p class="mb-1 font-weight-bold"><?php echo e(__('Is Smoking allowed')); ?></p>
            <label class="switch">
                <input type="checkbox" name="is_smoking"
                    <?php echo e($hotel_accommodation && $hotel_accommodation->is_smoking == ACTIVE_STATUS ? 'checked' : ''); ?>

                    class="blogIsFeaturedBtn">
                <span class="slider round"></span>
            </label>
        </div>
    </div>
    <div class="col-sm-3">
        <div class="form-group">
            <p class="h6 mb-3">
                <?php echo e(__('Feature Image')); ?>:<code><?php echo e(__('(Only jpeg, png, jpg and gif file is
                acceptable)')); ?></code>
            </p>
            <div class="">
                <div class="room_image" data-name="room_image" id="feature_image">
                    <div class="input-images"></div>
                </div>
            </div>
            <br>
            <?php if(count($room_images)): ?>
                <table class="table table-striped table-bordered miw-500">
                    <tbody>
                        <?php $__currentLoopData = $room_images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $room_image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td class="p-1">
                                    <img width="50" src="<?php echo e(asset('upload/hotel-accommodation/' . $room_image)); ?>"
                                        alt="">
                                </td>
                                <td width="100">
                                    <a href="javascript:void(0)" title="<?php echo e(__('Delete')); ?>"
                                        class="serviceDestroyBtn btn btn-sm btn btn-danger m-1">
                                        <?php echo e(__('Delete')); ?>

                                        <div class="deleteForm">
                                            <?php echo csrf_field(); ?>
                                            <input type="hidden" name="hotel_accommoddation_id"
                                                value="<?php echo e($hotel_accommodation->id); ?>">
                                            <input type="hidden" name="image" value="<?php echo e($room_image); ?>">
                                        </div>
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php /**PATH E:\php 8.2 projects\htdocs\touranCodester\resources\views/backend/pages/hotel/hotel-accommodation/include.blade.php ENDPATH**/ ?>