<?php if($hotels->count()): ?>
    <div class="row grid-mb">
        <?php $__currentLoopData = $hotels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hotel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php
                $discount = $hotel->discount ? $hotel->discount->discount : null;
                $route = route('single-hotel', $hotel->id);
            ?>
            <div class="col-lg-12">
                <div class="latest-hotel">
                    <div class="thumb">
                        <a href="<?php echo e($route); ?>">
                            <?php echo imageShow(asset(UPLOAD_FOLDER_HOTELS.$hotel->feature_image), __('Feature Image'), ''); ?>

                        </a>
                    </div>
                    <div class="content">
                        <a href="<?php echo e($route); ?>">
                            <h4><?php echo e(clean($hotel ? $hotel->hotel_name : '')); ?></h4>
                        </a>
                        <h5><?php echo e(Str::limit(clean($hotel ? $hotel->hotel_location : ''), 100)); ?></h5>
                        <p><?php echo e(Str::limit(clean($hotel ? $hotel->description : ''), 100)); ?></p>
                        <a class="map-viw hotel_map" href="#hotel_map_modal" data-toggle="modal"
                            data-lat="<?php echo e($hotel->latitude); ?>" data-lng="<?php echo e($hotel->longitude); ?>"
                            data-name="<?php echo e($hotel->hotel_name); ?>"><i
                                class="fa fa-map-marker"></i><?php echo e(__('View on Map')); ?></a>
                            <?php if($hotel->price): ?>
                                <p class="price"><?php echo e(__('One Night Price')); ?>: <?php echo e(currencyFormat($hotel->price)); ?></p>
                            <?php endif; ?>
                        <?php if($discount): ?>
                            <h3><?php echo e(__('Off')); ?>

                                <span>-<?php echo e(discountPriceShow($discount)); ?></span>
                            </h3>
                        <?php endif; ?>
                        <div class="clearfix"></div>
                        <a class="btn-theme" href="<?php echo e($route); ?>">
                            <?php echo e(__('View Deal')); ?>

                            <svg width="16" height="16" fill="currentColor" class="bi bi-chevron-right ml-1" viewBox="0 0 16 16">
                                <path fill-rule="evenodd" d="M4.646 1.646a.5.5 0 0 1 .708 0l6 6a.5.5 0 0 1 0 .708l-6 6a.5.5 0 0 1-.708-.708L10.293 8 4.646 2.354a.5.5 0 0 1 0-.708z"/>
                            </svg>
                        </a>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>

    <div class="row">
        <div class="col-md-12">
            <?php if($hotels instanceof \Illuminate\Pagination\LengthAwarePaginator): ?>
                <?php echo e($hotels->links('frontend.pagination.index')); ?>

            <?php endif; ?>
        </div>
    </div>
    <?php echo $__env->make('frontend.pages.hotel.map-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php else: ?>
    <div class="alert alert-warning text-center">
        <i class="fa fa-search fa-5x mb-3" aria-hidden="true"></i>
        <h4><?php echo e(__('No hotel found')); ?></h4>
    </div>
<?php endif; ?>
<?php /**PATH /home/www/bdctravel.bdcoder.com/resources/views/frontend/pages/hotel/list.blade.php ENDPATH**/ ?>