
<?php $__env->startSection('title', config('app.name', 'laravel') . ' | ' . $title); ?>
<?php $__env->startSection('page-css'); ?>
    <link href="<?php echo e(asset('backend/assets/plugin/select2/select2.min.css')); ?>" rel="stylesheet" />
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div id="wrapper-content">
        <div class="row">
            <div class="col">
                <nav class="breadcrumb justify-content-sm-start justify-content-center text-center text-light bg-dark ">
                    <a class="breadcrumb-item text-white" href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Home')); ?></a>
                    <span class="breadcrumb-item active"><?php echo e($title); ?></span>
                    <span class="breadcrumb-info" id="time"></span>
                </nav>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card card-dark bg-dark">
                    <?php if($package): ?>
                        <div class="card-header d-block">
                            <div class="row">
                                <div class="col-md-6 col-sm-12">
                                    <ul class="nav nav-tabs border-0">
                                        <li class="nav-item">
                                            <a class="nav-link"
                                                href="<?php echo e(route('admin.packages.edit', $package->id)); ?>"><?php echo e(__('Package')); ?></a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link active" href="#"><?php echo e(__('Sub Price')); ?></a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" href="#"><?php echo e(__('Departure')); ?></a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="card-body p-0">
                            <form action="<?php echo e(route('admin.package-subprice.package.update', $package->id)); ?>"
                                method="POST" enctype="multipart/form-data" class="wma-form">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('put'); ?>
                                <div class="row">
                                    <div class="col-md-6 col-sm-12">
                                        <p class="mb-1"><label for="name"
                                                class="card-title font-weight-bold"><?php echo e(__('Package : ')); ?>

                                                <?php echo e($package->title); ?></label></p>
                                    </div>
                                    <div class="col-md-6 col-sm-12 text-right">
                                        <button type="button" id="add-button" class="btn btn-danger btn-sm rounded"><i
                                                class="material-icons"><?php echo e(__('add')); ?></i></button>
                                    </div>
                                </div>
                                <table class="table table-bordered">
                                    <thead>
                                        <tr>
                                            <td><?php echo e(__('Group')); ?></td>
                                            <td><?php echo e(__('Amount')); ?></td>
                                            <td width="50"></td>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php if(count($package->subPrice)): ?>
                                            <?php $__currentLoopData = $package->subPrice; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td><input type="text" name="group_size[]"
                                                            value="<?php echo e($item->group_size); ?>" class="form-control"
                                                            required>
                                                    </td>
                                                    <td><input type="text" name="sub_price[]"
                                                            value="<?php echo e($item->tour_price); ?>" class="form-control"
                                                            required></td>
                                                    <td>
                                                        <input type="hidden" name="subprice_id[]"
                                                            value="<?php echo e($item->id); ?>">
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php else: ?>
                                            <tr>
                                                <td colspan="3"><?php echo e(__('To add new price click add button')); ?></td>
                                            </tr>
                                        <?php endif; ?>
                                    </tbody>
                                </table>
                                <div class="wizard-action text-left">
                                    <button data-route="<?php echo e(route('admin.package-departure.create')); ?>"
                                        class="btn btn-wave-light btn-secondary btn-lg skip"><?php echo e(__('Skip')); ?></button>
                                    <button class="btn btn-wave-light btn-danger btn-lg"
                                        type="submit"><?php echo e(__('Next')); ?></button>
                                </div>
                            </form>
                        </div>
                    <?php else: ?>
                        <div class="card-header d-block">
                            <h6 class="card-title lh-35"><?php echo e(__('Package Sub Price Edit')); ?></h6>
                        </div>
                        <div class="card-body p-0">
                            <div class="row">
                                <div class="col-md-12">
                                    <form action="<?php echo e(route('admin.package-subprice.update', $package_sub_price->id)); ?>"
                                        method="POST" enctype="multipart/form-data" class="wma-form">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('put'); ?>
                                        <div class="row">
                                            <div class="col-sm-6">
                                                <div class="form-group">
                                                    <label for=""><?php echo e(__('Group')); ?></label>
                                                    <input type="text" name="group_size"
                                                            value="<?php echo e($package_sub_price->group_size); ?>" class="form-control"
                                                            required>
                                                </div>
                                            </div>
                                            <div class="col-sm-6">
                                                <div class="form-group">
                                                    <label for=""><?php echo e(__('Amount')); ?></label>
                                                    <input type="text" name="sub_price"
                                                            value="<?php echo e($package_sub_price->tour_price); ?>" class="form-control"
                                                            required>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="wizard-action text-left">
                                            <button class="btn btn-wave-light btn-danger btn-lg"
                                                type="submit"><?php echo e(__('Save')); ?></button>
                                                <input type="hidden" name="subprice_id"
                                                            value="<?php echo e($package_sub_price->id); ?>">
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('page-script'); ?>
    <script src="<?php echo e(asset('backend/assets/plugin/select2/select2.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/assets/js/package/subprice.js')); ?>"></script>
    <?php echo $__env->make('backend.pages.blogs.internal-assets.js.delete-warning', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('backend.layouts.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.master-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\php 8.2 projects\htdocs\touranCodester\resources\views/backend/pages/packages/subprice/edit.blade.php ENDPATH**/ ?>