

<?php $__env->startSection('title', config('app.name', 'laravel') . ' | ' . $title); ?>

<?php $__env->startSection('page-css'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Inner Section Start -->
    <section class="inner-area parallax-bg" style="<?php if(!empty($pageContent->bg_img)): ?>background-image: url(<?php echo e(asset($pageContent->bg_img)); ?>); <?php endif; ?>">
        <div class="container">
            <div class="section-content">
                <div class="row">
                    <div class="col-12">
                        <h4><?php echo e(isset($title) ? clean($title) : ''); ?></h4>
                        <p><a href="<?php echo e(route('home')); ?>"><?php echo e(__('Home')); ?></a> <a><?php echo e(isset($title) ? clean($title) : ''); ?></a></p>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Inner Section End -->

    <!-- Blog Section Start -->
    <section class="blog-section">
        <div class="container">
            <div class="row">
                <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-md-6 col-lg-4">
                        <div class="blog-post">
                            <div class="thumb">
                                <a href="<?php echo e(route('view-single-blog-page', ['slug' => $blog->slug])); ?>">
                                    <?php echo imageShow($blog->feature_img, __('Blog Image')); ?>

                                </a>
                                <div class="content">
                                    <a href="<?php echo e(route('view-single-blog-page', ['slug' => $blog->slug])); ?>">
                                        <h3><?php echo e(clean($blog ? $blog->title : '')); ?></h3>
                                    </a>
                                    <div class="meta-box">
                                        <div class="admin-post"> <?php echo e((isset($blog->userId)) ? $blog->userId->name : ''); ?> </div>
                                        <div class="inner">
                                            <div class="date">
                                                <i class="fa fa-calendar-plus-o"></i>
                                                <?php echo e(date('M', strtotime($blog->created_at))); ?>

                                                <b><?php echo e(date('d', strtotime($blog->created_at))); ?></b>
                                            </div>
                                            <div class="comment">
                                                <i class="fa fa-commenting-o"></i> 8
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <a href="<?php echo e(route('view-single-blog-page', ['slug' => $blog->slug])); ?>"
                                class="read-btn"><?php echo e(__('Continue Reading')); ?>

                                <i class="fa fa-long-arrow-right" aria-hidden="true"></i>
                            </a>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </section>
    <!-- Blog Section End -->

    <section class="text-center pt-0 pb-70">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <?php echo e($blogs->links('frontend.pagination.index')); ?>

                </div>
            </div>
        </div>
    </section>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-script'); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.master-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/www/bdctravel.bdcoder.com/resources/views/frontend/pages/blog/index.blade.php ENDPATH**/ ?>