
<?php $__env->startSection('title', config('app.name', 'laravel') . ' | ' . $title); ?>
<?php $__env->startSection('page-css'); ?>
    <link href="<?php echo e(asset('backend/assets/plugin/select2/select2.min.css')); ?>" rel="stylesheet" />
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div id="wrapper-content">
        <div class="row">
            <div class="col">
                <nav class="breadcrumb justify-content-sm-start justify-content-center text-center text-light bg-dark ">
                    <a class="breadcrumb-item text-white" href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Home')); ?></a>
                    <a class="breadcrumb-item text-white" href="<?php echo e(route('admin.place.index')); ?>"><?php echo e(__('Place')); ?></a>
                    <span class="breadcrumb-item active"><?php echo e(__($title)); ?></span>
                    <span class="breadcrumb-info" id="time"></span>
                </nav>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card card-dark bg-dark">
                    <div class="card-header">
                        <h6 class="card-title"><?php echo e(__($title)); ?></h6>
                    </div>
                    <form action="<?php echo e($place ? route('admin.place.update', $place->id) : route('admin.place.store')); ?>"
                        method="post" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <?php if($place): ?>
                            <?php echo method_field('PATCH'); ?>
                        <?php endif; ?>
                        <div class="card-body ">
                            <div class="form-row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <p class="mb-1 font-weight-bold"><?php echo e(__('Place Name :')); ?> </p>
                                        <input type="text" name="name" class="form-control" aria-label="Large"
                                            aria-describedby="inputGroup-sizing-sm" placeholder="<?php echo e(__('Place Name')); ?>"
                                            value="<?php echo e($place ? $place->name : old('name')); ?>" required>
                                        <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="text-danger"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>

                                <div class="col-md-12">
                                    <p class="h6 mb-3"><?php echo e(__('Place Primary Image')); ?>:<code><?php echo e(__('(Only jpeg, png, jpg and gif file is
                                        acceptable)')); ?></code></p>
                                    <div class="row mb-3">
                                        <div class="col-md-6">
                                            <div class="">
                                                <div class="thumbnail-image" id="bg_image">
                                                    <div class="input-images"></div>
                                                </div>
                                            </div>
                                        </div>
                                        <?php if($place): ?>
                                        <div class="col-md-6 text-center">
                                            <?php echo imageShow($place->place_primary_image, 'Image', 'img-thumbnail', 'width="35%" height="200"',  'App\Models\Place', $place->id, 'place_primary_image'); ?>


                                        </div>
                                        <?php endif; ?>
                                    </div>
                                    <?php $__errorArgs = ['images.0'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="invalid-feedback d-block"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer">
                            <div class="wizard-action text-left">
                                <button class="btn btn-wave-light btn-danger btn-lg"
                                    type="submit"><?php echo e(__('Submit form')); ?></button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-script'); ?>
    <script src="<?php echo e(asset('backend/assets/plugin/select2/select2.min.js')); ?>"></script>
    <?php echo $__env->make('backend.pages.place.internal-assets.js.page-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('backend.layouts.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('backend.pages.delete-warning', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.master-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\php 8.2 projects\htdocs\touranCodester\resources\views/backend/pages/place/form.blade.php ENDPATH**/ ?>