
<?php $__env->startSection('title', config('app.name', 'laravel') . ' | ' . $title); ?>
<?php $__env->startSection('page-css'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div id="wrapper-content">
        <div class="row">
            <div class="col">
                <nav class="breadcrumb justify-content-sm-start justify-content-center text-light bg-dark text-center">
                    <a class="breadcrumb-item text-white" href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Home')); ?></a>
                    <span class="breadcrumb-item active"><?php echo e(__($title)); ?></span>
                    <span class="breadcrumb-info" id="time"></span>
                </nav>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card card-dark bg-dark">

                    <div class="card-header d-block">
                        <div class="row">
                            <div class="col-md-6 col-sm-12">
                                <h6 class="card-title lh-35"><?php echo e(__($title)); ?></h6>
                            </div>
                            <div class="col-md-6 col-sm-12 text-right">
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="slider" class="bapric_table table-striped table-bordered miw-500 table"
                                   cellspacing="0" width="100%">
                                <thead>
                                    <tr>
                                        <th width="5%"><?php echo e(__('SL')); ?></th>
                                        <th><?php echo e(__('Logo')); ?></th>
                                        <th><?php echo e(__('Payment')); ?></th>
                                        <th><?php echo e(__('Details')); ?></th>
                                        <th><?php echo e(__('Status')); ?></th>
                                        <th><?php echo e(__('Default')); ?></th>
                                        <th width="10%"><?php echo e(__('Action')); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($loop->index + 1); ?></td>
                                            <td>
                                                <img src="<?php echo e($payment->logo); ?>" alt="Logo" width="80">
                                            </td>
                                            <td>
                                                <?php echo e(__('Type: ')); ?><?php echo e($payment->method_type); ?> <br>
                                                <?php echo e(__('Name: ')); ?><?php echo e($payment->name); ?>

                                            </td>
                                            <td>
                                                <?php if($payment->method_type == PAYPAL_PAYMENT): ?>
                                                    <b><?php echo e(__('Account:')); ?></b> <?php echo e($payment->account); ?> <br>
                                                    <b><?php echo e(__('Client ID:')); ?></b>
                                                    <?php echo e(Str::limit($payment->client_id, 25)); ?><br>
                                                <?php elseif($payment->method_type == STRIPE_PAYMENT): ?>
                                                    <b><?php echo e(__('Api Key:')); ?></b>
                                                    <?php echo e(Str::limit($payment->api_id, 25)); ?><br>
                                                <?php endif; ?>
                                                <b><?php echo e(__('Secret Key:')); ?></b>
                                                <?php echo e(Str::limit($payment->secret_key, 25)); ?><br>
                                            </td>
                                            <td>
                                                <label class="switch">
                                                    <input type="checkbox"
                                                           <?php echo e($payment->status == ACTIVE_STATUS ? 'checked' : ''); ?>

                                                           data-id="<?php echo e($payment->id); ?>" data-status="<?php echo e($payment->status); ?>" class="payment_status_change">
                                                    <span class="slider round"></span>
                                                </label>
                                            </td>
                                            <td>
                                                <label class="switch">
                                                    <input id="payment_default_change_<?php echo e($payment->id); ?>" type="checkbox"
                                                           <?php echo e($payment->is_default == ACTIVE_STATUS ? 'checked' : ''); ?>

                                                           data-id="<?php echo e($payment->id); ?>" class="payment_default_change">
                                                    <span class="slider round"></span>
                                                </label>
                                            </td>
                                            <td>
                                                <div class="d-flex">
                                                    <a href="<?php echo e(route('admin.payment.edit', $payment->id)); ?>">
                                                        <button type="button"
                                                                class="btn btn-sm btn btn-success blogCategoryEditBtn m-1"
                                                                data-id="<?php echo e($payment->id); ?>"><?php echo e(__('Edit')); ?></button>
                                                    </a>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('page-script'); ?>
    <?php echo $__env->make('backend.pages.payment.scripts.delete-warning', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('backend.pages.payment.scripts.payment-method-script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <script src="<?php echo e(asset('backend/assets/js/service-activation.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.master-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\php 8.2 projects\htdocs\touranCodester\resources\views/backend/pages/payment/index.blade.php ENDPATH**/ ?>