

<?php $__env->startSection('title', config('app.name', 'laravel') . ' | ' . $title); ?>

<?php $__env->startSection('page-css'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('frontend/css/images-grid.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/daterangepicker.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('/backend/assets/css/all.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('frontend/css/payment.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Inner Section Start -->
    <section class="inner-area parallax-bg" style="<?php if(!empty($pageContent->bg_img)): ?> background-image: url(<?php echo e(asset($pageContent->bg_img)); ?>); <?php endif; ?>">
        <div class="container">
            <div class="section-content">
                <div class="row">
                    <div class="col-12">
                        <h4><?php echo e(isset($title) ? $title : ''); ?></h4>
                        <p><a href="<?php echo e(route('home')); ?>"><?php echo e(__('Home')); ?></a>
                            <a><?php echo e(isset($title) ? $title : ''); ?></a>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Inner Section End -->

    <!-- Contact Section Start -->
    <div class="container mt-3">
        <?php if(Session::get('message')): ?>
            <div class="alert alert-success"><?php echo e(Session::get('message')); ?></div>
        <?php endif; ?>
    </div>
    <section class="contact-section pt-5 pb-20">
        <div class="container">
            <div class="checkout-form">
                <div class="checkout-section">
                    <div class="checkout-header">
                        <h3><?php echo e(__('Complete Payment')); ?></h3>
                    </div>
                    <div class="checkout-table">
                        <div class="ctable-head ct-row">
                            <div class="column"><?php echo e(__('Description')); ?></div>
                            <div class="column"><?php echo e(__('Amount')); ?></div>
                        </div>
                        <div class="ctable-body">
                            <div class="ct-row">
                                <div class="column">
                                    <h5 class="name"><?php echo e($booking->package->title); ?></h5>
                                    <p class="desc"><?php echo e(__('Location: ')); ?> <?php echo e($booking->package->location); ?></p>
                                </div>
                                <div class="column">
                                    <strong class="amount"><?php echo e(discountPriceCalculate($booking->packageSubPrice->tour_price, $booking->package->discount)['price']); ?></strong>
                                    <span class="qty"><?php echo e($booking->packageSubPrice->group_size); ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="ctable-foot ct-row">
                            <div class="column"><?php echo e(__('Total')); ?></div>
                            <div class="column">
                                <strong><?php echo e(discountPriceCalculate($booking->packageSubPrice->tour_price, $booking->package->discount)['price']); ?></strong>
                            </div>
                        </div>
                        <div id="inside-checkout">
                            <?php if($booking->status == BOOKING_STATUS_CONFIRM): ?>
                                <div class="alert alert-info mt-5">
                                    <strong><?php echo e(__('Notice!')); ?></strong> <?php echo e(__('Your payment was processed successfully.')); ?>

                                    <div><?php echo e(__('Package Booking confirmed. Package authority will review your booking and give
                                        you confirmation.')); ?></div>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="checkout-footer">
                        <div class="square">

                        </div>
                        <div class="text">
                            <?php echo e(__('Please, pay the amount by the methods dispayed on the right.')); ?>

                        </div>
                    </div>
                </div>
                <div class="payment-section">
                    <div class="payment-option <?php echo e($paypal->is_default == 1 ? 'active' : ''); ?>">
                        <div class="option-head" id="method1">
                            <div class="arrow">
                                <i class="fa fa-chevron-right"></i>
                            </div>
                            <div class="text">
                                <h4><?php echo e(__('PayPal')); ?></h4>
                                <p class="mb-0"><?php echo e(__('Pay with PayPal Payment System')); ?></p>
                            </div>
                        </div>
                        <div class="option-body" <?php echo e($paypal->is_default == 1 ? 'style="disblay: block"' : 'style="display: none"'); ?>>
                            <div class="method_container mt-3" id="method_container1">
                                <?php if($booking->status != BOOKING_STATUS_CONFIRM): ?>
                                    <div class="loading text-center pt-3" style="display: none">
                                        <div class="spinner py-3">
                                            <i class="fa fa-circle-o-notch fa-spin fa-3x fa-fw"></i>
                                            <span class="sr-only"><?php echo e(__('Loading...')); ?></span>
                                        </div>
                                    </div>
                                    <div id="paypal_container"></div>
                                <?php else: ?>
                                    <div class="alert alert-info text-center"><?php echo e(__('Payment is already completed')); ?></div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <div class="payment-option <?php echo e($stripe->is_default == 1 ? 'active' : ''); ?>">
                        <div class="option-head" id="method2">
                            <div class="arrow">
                                <i class="fa fa-chevron-right"></i>
                            </div>
                            <div class="text">
                                <h4><?php echo e(__('Credit / Debit Card')); ?></h4>
                                <p class="mb-0"><?php echo e(__('Pay via Credit / Debit Card')); ?></p>
                            </div>
                        </div>
                        <div class="option-body" <?php echo e($stripe->is_default == 1 ? 'style="disblay: block"' : 'style="display: none"'); ?>>
                            <div class="method_container mt-3" id="method_container2">
                                <?php if($booking->status != BOOKING_STATUS_CONFIRM): ?>
                                    <div class="loading text-center pt-3" style="display: none">
                                        <div class="spinner py-3">
                                            <i class="fa fa-circle-o-notch fa-spin fa-3x fa-fw"></i>
                                            <span class="sr-only"><?php echo e(__('Loading...')); ?></span>
                                        </div>
                                    </div>
                                    <div id="stripe_container" class="mb-3 mt-2">
                                        <form method="POST" action="<?php echo e(route('stripe.capture')); ?>" class="booking-form my-3" id="stripe_card_form"> <?php echo csrf_field(); ?>
                                            <input type="hidden" name="payment_method" class="stripe_payment_method" id="stripe_payment_method">
                                            <div class="form-row">
                                                <div class="form-group col-md-9">
                                                    <label for="card_number"><?php echo e(__('Card Number')); ?></label>
                                                    <div id="card_number"></div>
                                                </div>
                                                <div class="form-group col-md-3">
                                                    <label for="card_cvc"><?php echo e(__('CVC')); ?></label>
                                                    <div id="card_cvc"></div>
                                                </div>
                                                <div class="form-group col-md-8">
                                                    <label for="card_cvc"><?php echo e(__('Name on Card')); ?></label>
                                                    <input class="StripeElement w-100 mb-3" name="card_holder_name" placeholder="<?php echo e(__('Cardholder Name')); ?>" required id="stripe_card_holder_name" autocomplete="off">
                                                </div>
                                                <div class="form-group col-md-4">
                                                    <label for="card_expiry"><?php echo e(__('Expiration date')); ?></label>
                                                    <div id="card_expiry"></div>
                                                </div>
                                                <div class="form-group col-md-12">
                                                    <div class="text-center text-danger" id="card_errors"></div>
                                                </div>
                                                <div class="form-group col-md-12">
                                                    <div class="contact-textarea text-center">
                                                        <button class="btn btn-theme" type="submit" id="stripe_pay" value="Submit Form"><?php echo e(__('Pay Now')); ?></button>
                                                    </div>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                <?php else: ?>
                                    <div class="alert alert-info text-center"><?php echo e(__('Payment is already completed')); ?></div>
                                <?php endif; ?>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Contact Section End -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-script'); ?>
    <script type="text/javascript" src="<?php echo e(asset('js/moment.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('js/daterangepicker.js')); ?>"></script>
    <script src="<?php echo e(asset('frontend/vendor/axios.min.js')); ?>"></script>
    <script src="<?php echo e(asset('notification_assets/js/sweetalert.min.js')); ?>"></script>
    <script>const PAYABLE_AMOUNT = parseFloat("<?php echo e(discountPriceCalculate($booking->packageSubPrice->tour_price, $booking->package->discount, false)['price']); ?>"); </script>
        <?php $__currentLoopData = $methods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $method): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if($method->method_type == PAYPAL_PAYMENT): ?>
                <?php echo $__env->make('frontend.scripts.paypal-js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> <?php endif; ?>
            <?php if($method->method_type == STRIPE_PAYMENT): ?>
                <?php echo $__env->make('frontend.scripts.stripe-js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <script src="<?php echo e(asset('frontend/js/payment.js')); ?>"></script>
        <script defer>
            <?php if($paypal->is_default == 1): ?>
                $("#method1").parent().find(".option-body").show();
            <?php elseif($stripe->is_default == 1): ?>
                $("#method2").parent().find(".option-body").show();
            <?php endif; ?>
            <?php if($booking->status != BOOKING_STATUS_CONFIRM): ?>
                <?php if($paypal->is_default == 1): ?>
                    loadPayPalButton();
                <?php elseif($stripe->is_default == 1): ?>
                    loadStripeCardForm();
                <?php endif; ?>
            <?php endif; ?>
        </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.master-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\php 8.2 projects\htdocs\touranCodester\resources\views/frontend/pages/booking/payment/package.blade.php ENDPATH**/ ?>