
<?php $__env->startSection('title', config('app.name', 'laravel') . ' | ' . $title); ?>
<?php $__env->startSection('page-css'); ?>
    <link href="<?php echo e(asset('backend/assets/plugin/select2/select2.min.css')); ?>" rel="stylesheet" />
    <link rel="stylesheet" href="<?php echo e(asset('css/daterangepicker.css')); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div id="wrapper-content">
        <div class="row">
            <div class="col">
                <nav class="breadcrumb justify-content-sm-start justify-content-center text-center text-light bg-dark ">
                    <a class="breadcrumb-item text-white" href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Home')); ?></a>
                    <span class="breadcrumb-item active"><?php echo e($title); ?></span>
                    <span class="breadcrumb-info" id="time"></span>
                </nav>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card card-dark bg-dark">
                    <div class="card-header d-block">
                        <div class="row">
                            <div class="col-md-6 col-sm-12">
                                <h5><?php echo e($title); ?></h5>
                            </div>
                        </div>
                    </div>
                    <div class="card-body p-0">
                        <form
                            action="<?php echo e($discount ? route('admin.discounts.update', $discount->id) : route('admin.discounts.store')); ?>"
                            method="POST" class="wma-form" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <?php if($discount): ?>
                                <?php echo method_field('PUT'); ?>
                            <?php endif; ?>
                            <p class="mb-1"><label for="title"
                                    class="card-title font-weight-bold"><?php echo e(__('Title :')); ?></label></p>
                            <div class="input-group input-group-lg mb-3">
                                <input type="text" name="title" class="form-control" aria-label="Large"
                                    aria-describedby="inputGroup-sizing-sm" placeholder="<?php echo e(__('Title')); ?>"
                                    value="<?php echo e($discount ? $discount->title : old('title')); ?>">
                                <?php $__errorArgs = ['departure_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="invalid-feedback d-block"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <p class="mb-1"><label for="price"
                                    class="card-title font-weight-bold"><?php echo e(__('Package :')); ?></label></p>
                            <div class="input-group input-group-lg mb-3">
                                <select type="text" name="package[]" multiple="multiple" class="form-control"
                                    aria-label="Large" aria-describedby="inputGroup-sizing-sm" id="package">
                                    <option value=""><?php echo e(__('Select')); ?></option>
                                    <?php $__currentLoopData = $package; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pkg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option
                                            <?php echo e($discount && (count($discount_package) && in_array($pkg->id, $discount_package)) ? 'selected' : ''); ?>

                                            value="<?php echo e($pkg->id); ?>"><?php echo e($pkg->title); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php $__errorArgs = ['discount_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="invalid-feedback d-block"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <p class="mb-1"><label for="price"
                                    class="card-title font-weight-bold"><?php echo e(__('Hotel :')); ?></label></p>
                            <div class="input-group input-group-lg mb-3">
                                <select type="text" name="hotel[]" class="form-control" aria-label="Large"
                                    aria-describedby="inputGroup-sizing-sm" id="hotel" multiple="multiple">
                                    <option value=""><?php echo e(__('Select')); ?></option>
                                    <?php $__currentLoopData = $hotel; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $htl): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option
                                            <?php echo e($discount && (count($discount_hotel) && in_array($htl->id, $discount_hotel)) ? 'selected' : ''); ?>

                                            value="<?php echo e($htl->id); ?>"><?php echo e($htl->hotel_name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php $__errorArgs = ['discount_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="invalid-feedback d-block"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <p class="mb-1"><label for="price"
                                    class="card-title font-weight-bold"><?php echo e(__('Discount Type :')); ?></label></p>
                            <div class="input-group input-group-lg mb-3">
                                <select type="text" name="discount_type" class="form-control" aria-label="Large"
                                    aria-describedby="inputGroup-sizing-sm" required>
                                    <option value=""><?php echo e(__('Select')); ?></option>
                                    <?php $__currentLoopData = discountType(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $dt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option <?php echo e($discount && $discount->discount_type == $key ? 'selected' : ''); ?>

                                            value="<?php echo e($key); ?>"><?php echo e($dt); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php $__errorArgs = ['discount_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="invalid-feedback d-block"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <p class="mb-1"><label for="ammount"
                                    class="card-title font-weight-bold"><?php echo e(__('Amount:')); ?></label></p>
                            <div class="input-group input-group-lg mb-3">
                                <input type="number" step="any" min="0" name="amount" class="form-control"
                                    aria-label="Large" aria-describedby="inputGroup-sizing-sm"
                                    placeholder="<?php echo e(__('Amount')); ?>"
                                    value="<?php echo e($discount ? $discount->amount : old('amount')); ?>">
                                <?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="invalid-feedback d-block"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <p class="mb-1"><label for="details"
                                    class="card-title font-weight-bold"><?php echo e(__('Detail:')); ?></label></p>
                            <div class="input-group input-group-lg mb-3">
                                <input type="text" name="details" class="form-control" aria-label="Large"
                                    aria-describedby="inputGroup-sizing-sm" placeholder="<?php echo e(__('Details')); ?>"
                                    value="<?php echo e($discount ? $discount->details : old('details')); ?>">
                                <?php $__errorArgs = ['details'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="invalid-feedback d-block"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <p class="mb-1"><label for="start_date"
                                    class="card-title font-weight-bold"><?php echo e(__('Start End Date:')); ?></label></p>
                            <div class="input-group input-group-lg mb-3">
                                <input type="text" id="datetimepicker" name="start_end_date" class="form-control"
                                    value="<?php echo e($discount ? $start_end_date : old('start_end_date')); ?>" />
                                <?php $__errorArgs = ['start_end_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="invalid-feedback d-block"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-12">
                                <p class="h6 mb-3">
                                    <?php echo e(__('Images')); ?>:<code><?php echo e(__('(Only jpeg, png, jpg and gif file is
                                    acceptable)')); ?></code>
                                </p>
                                <div class="row mb-3">
                                    <div class="col-md-6">
                                        <div class="">
                                            <div class="thumbnail-image" id="thumbnail_image">
                                                <div class="input-images"></div>
                                            </div>
                                        </div>
                                    </div>
                                    <?php if($discount): ?>
                                        <div class="col-md-6 text-center">
                                            <?php echo imageShow($discount->images, 'Image', 'img-thumbnail', 'width="35%" height="200'); ?>

                                        </div>
                                    <?php endif; ?>
                                </div>
                                <?php $__errorArgs = ['images.0'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="invalid-feedback d-block"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="wizard-action text-left">
                                <button class="btn btn-wave-light btn-danger btn-lg"
                                    type="submit"><?php echo e(__('Submit')); ?></button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('page-script'); ?>
    <script src="<?php echo e(asset('backend/assets/plugin/select2/select2.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/assets/js/discount_sub.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('js/moment.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('js/daterangepicker.js')); ?>"></script>
    <?php echo $__env->make('backend.pages.blogs.internal-assets.js.delete-warning', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('backend.layouts.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('backend.pages.discount.script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.master-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\php 8.2 projects\htdocs\touranCodester\resources\views/backend/pages/discount/form.blade.php ENDPATH**/ ?>